package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{Arn, SkillId, Value, Key}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutSkillAuthorizationRequest(
    authorizationResult: Map[Key, Value],
    skillId: SkillId,
    roomArn: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.PutSkillAuthorizationRequest = {
    import PutSkillAuthorizationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.PutSkillAuthorizationRequest
      .builder()
      .authorizationResult(
        authorizationResult
          .map({ case (key, value) =>
            (Key.unwrap(key): java.lang.String) -> (Value.unwrap(
              value
            ): java.lang.String)
          })
          .asJava
      )
      .skillId(SkillId.unwrap(skillId): java.lang.String)
      .optionallyWith(
        roomArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.roomArn)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.PutSkillAuthorizationRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.PutSkillAuthorizationRequest
      .wrap(buildAwsValue())
}
object PutSkillAuthorizationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.PutSkillAuthorizationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.alexaforbusiness.model.PutSkillAuthorizationRequest =
      zio.aws.alexaforbusiness.model.PutSkillAuthorizationRequest(
        authorizationResult,
        skillId,
        roomArn.map(value => value)
      )
    def authorizationResult: Map[Key, Value]
    def skillId: SkillId
    def roomArn: Optional[Arn]
    def getAuthorizationResult: ZIO[Any, Nothing, Map[Key, Value]] =
      ZIO.succeed(authorizationResult)
    def getSkillId: ZIO[Any, Nothing, SkillId] = ZIO.succeed(skillId)
    def getRoomArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("roomArn", roomArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.PutSkillAuthorizationRequest
  ) extends zio.aws.alexaforbusiness.model.PutSkillAuthorizationRequest.ReadOnly {
    override val authorizationResult: Map[Key, Value] = impl
      .authorizationResult()
      .asScala
      .map({ case (key, value) =>
        zio.aws.alexaforbusiness.model.primitives
          .Key(key) -> zio.aws.alexaforbusiness.model.primitives.Value(value)
      })
      .toMap
    override val skillId: SkillId =
      zio.aws.alexaforbusiness.model.primitives.SkillId(impl.skillId())
    override val roomArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.roomArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.PutSkillAuthorizationRequest
  ): zio.aws.alexaforbusiness.model.PutSkillAuthorizationRequest.ReadOnly =
    new Wrapper(impl)
}
