package zio.aws.alexaforbusiness.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.alexaforbusiness.model.primitives.{MaxResults, NextToken}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class SearchRoomsRequest(
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.alexaforbusiness.model.Filter]] =
      Optional.Absent,
    sortCriteria: Optional[Iterable[zio.aws.alexaforbusiness.model.Sort]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.SearchRoomsRequest = {
    import SearchRoomsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.SearchRoomsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        sortCriteria.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sortCriteria)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.SearchRoomsRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.SearchRoomsRequest.wrap(buildAwsValue())
}
object SearchRoomsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.SearchRoomsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.SearchRoomsRequest =
      zio.aws.alexaforbusiness.model.SearchRoomsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sortCriteria.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def filters: Optional[List[zio.aws.alexaforbusiness.model.Filter.ReadOnly]]
    def sortCriteria
        : Optional[List[zio.aws.alexaforbusiness.model.Sort.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.alexaforbusiness.model.Filter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getSortCriteria: ZIO[Any, AwsError, List[
      zio.aws.alexaforbusiness.model.Sort.ReadOnly
    ]] = AwsError.unwrapOptionField("sortCriteria", sortCriteria)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.SearchRoomsRequest
  ) extends zio.aws.alexaforbusiness.model.SearchRoomsRequest.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.alexaforbusiness.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.alexaforbusiness.model.primitives.MaxResults(value))
    override val filters
        : Optional[List[zio.aws.alexaforbusiness.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.alexaforbusiness.model.Filter.wrap(item)
          }.toList
        )
    override val sortCriteria
        : Optional[List[zio.aws.alexaforbusiness.model.Sort.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortCriteria())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.alexaforbusiness.model.Sort.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.SearchRoomsRequest
  ): zio.aws.alexaforbusiness.model.SearchRoomsRequest.ReadOnly = new Wrapper(
    impl
  )
}
