package zio.aws.alexaforbusiness.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.alexaforbusiness.model.primitives.{MaxResults, NextToken, Arn}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListGatewaysRequest(
    gatewayGroupArn: Optional[Arn] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.ListGatewaysRequest = {
    import ListGatewaysRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.ListGatewaysRequest
      .builder()
      .optionallyWith(
        gatewayGroupArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.gatewayGroupArn)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.ListGatewaysRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.ListGatewaysRequest.wrap(buildAwsValue())
}
object ListGatewaysRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.ListGatewaysRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.ListGatewaysRequest =
      zio.aws.alexaforbusiness.model.ListGatewaysRequest(
        gatewayGroupArn.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def gatewayGroupArn: Optional[Arn]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getGatewayGroupArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("gatewayGroupArn", gatewayGroupArn)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.ListGatewaysRequest
  ) extends zio.aws.alexaforbusiness.model.ListGatewaysRequest.ReadOnly {
    override val gatewayGroupArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.gatewayGroupArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.alexaforbusiness.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.alexaforbusiness.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.ListGatewaysRequest
  ): zio.aws.alexaforbusiness.model.ListGatewaysRequest.ReadOnly = new Wrapper(
    impl
  )
}
