package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetSkillGroupResponse(
    skillGroup: Optional[zio.aws.alexaforbusiness.model.SkillGroup] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.GetSkillGroupResponse = {
    import GetSkillGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.GetSkillGroupResponse
      .builder()
      .optionallyWith(skillGroup.map(value => value.buildAwsValue()))(
        _.skillGroup
      )
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.GetSkillGroupResponse.ReadOnly =
    zio.aws.alexaforbusiness.model.GetSkillGroupResponse.wrap(buildAwsValue())
}
object GetSkillGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.GetSkillGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.GetSkillGroupResponse =
      zio.aws.alexaforbusiness.model
        .GetSkillGroupResponse(skillGroup.map(value => value.asEditable))
    def skillGroup: Optional[zio.aws.alexaforbusiness.model.SkillGroup.ReadOnly]
    def getSkillGroup: ZIO[
      Any,
      AwsError,
      zio.aws.alexaforbusiness.model.SkillGroup.ReadOnly
    ] = AwsError.unwrapOptionField("skillGroup", skillGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.GetSkillGroupResponse
  ) extends zio.aws.alexaforbusiness.model.GetSkillGroupResponse.ReadOnly {
    override val skillGroup
        : Optional[zio.aws.alexaforbusiness.model.SkillGroup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.skillGroup())
        .map(value => zio.aws.alexaforbusiness.model.SkillGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.GetSkillGroupResponse
  ): zio.aws.alexaforbusiness.model.GetSkillGroupResponse.ReadOnly =
    new Wrapper(impl)
}
