package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{
  ClientRequestToken,
  RawPhoneNumber,
  ContactName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateContactRequest(
    displayName: Optional[ContactName] = Optional.Absent,
    firstName: ContactName,
    lastName: Optional[ContactName] = Optional.Absent,
    phoneNumber: Optional[RawPhoneNumber] = Optional.Absent,
    phoneNumbers: Optional[
      Iterable[zio.aws.alexaforbusiness.model.PhoneNumber]
    ] = Optional.Absent,
    sipAddresses: Optional[
      Iterable[zio.aws.alexaforbusiness.model.SipAddress]
    ] = Optional.Absent,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.alexaforbusiness.model.Tag]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.CreateContactRequest = {
    import CreateContactRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.CreateContactRequest
      .builder()
      .optionallyWith(
        displayName.map(value => ContactName.unwrap(value): java.lang.String)
      )(_.displayName)
      .firstName(ContactName.unwrap(firstName): java.lang.String)
      .optionallyWith(
        lastName.map(value => ContactName.unwrap(value): java.lang.String)
      )(_.lastName)
      .optionallyWith(
        phoneNumber.map(value => RawPhoneNumber.unwrap(value): java.lang.String)
      )(_.phoneNumber)
      .optionallyWith(
        phoneNumbers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.phoneNumbers)
      .optionallyWith(
        sipAddresses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sipAddresses)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.CreateContactRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.CreateContactRequest.wrap(buildAwsValue())
}
object CreateContactRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.CreateContactRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.CreateContactRequest =
      zio.aws.alexaforbusiness.model.CreateContactRequest(
        displayName.map(value => value),
        firstName,
        lastName.map(value => value),
        phoneNumber.map(value => value),
        phoneNumbers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sipAddresses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clientRequestToken.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def displayName: Optional[ContactName]
    def firstName: ContactName
    def lastName: Optional[ContactName]
    def phoneNumber: Optional[RawPhoneNumber]
    def phoneNumbers
        : Optional[List[zio.aws.alexaforbusiness.model.PhoneNumber.ReadOnly]]
    def sipAddresses
        : Optional[List[zio.aws.alexaforbusiness.model.SipAddress.ReadOnly]]
    def clientRequestToken: Optional[ClientRequestToken]
    def tags: Optional[List[zio.aws.alexaforbusiness.model.Tag.ReadOnly]]
    def getDisplayName: ZIO[Any, AwsError, ContactName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getFirstName: ZIO[Any, Nothing, ContactName] = ZIO.succeed(firstName)
    def getLastName: ZIO[Any, AwsError, ContactName] =
      AwsError.unwrapOptionField("lastName", lastName)
    def getPhoneNumber: ZIO[Any, AwsError, RawPhoneNumber] =
      AwsError.unwrapOptionField("phoneNumber", phoneNumber)
    def getPhoneNumbers: ZIO[Any, AwsError, List[
      zio.aws.alexaforbusiness.model.PhoneNumber.ReadOnly
    ]] = AwsError.unwrapOptionField("phoneNumbers", phoneNumbers)
    def getSipAddresses: ZIO[Any, AwsError, List[
      zio.aws.alexaforbusiness.model.SipAddress.ReadOnly
    ]] = AwsError.unwrapOptionField("sipAddresses", sipAddresses)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.alexaforbusiness.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.CreateContactRequest
  ) extends zio.aws.alexaforbusiness.model.CreateContactRequest.ReadOnly {
    override val displayName: Optional[ContactName] = zio.aws.core.internal
      .optionalFromNullable(impl.displayName())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.ContactName(value)
      )
    override val firstName: ContactName =
      zio.aws.alexaforbusiness.model.primitives.ContactName(impl.firstName())
    override val lastName: Optional[ContactName] = zio.aws.core.internal
      .optionalFromNullable(impl.lastName())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.ContactName(value)
      )
    override val phoneNumber: Optional[RawPhoneNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.phoneNumber())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.RawPhoneNumber(value)
      )
    override val phoneNumbers
        : Optional[List[zio.aws.alexaforbusiness.model.PhoneNumber.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.phoneNumbers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.alexaforbusiness.model.PhoneNumber.wrap(item)
          }.toList
        )
    override val sipAddresses
        : Optional[List[zio.aws.alexaforbusiness.model.SipAddress.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sipAddresses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.alexaforbusiness.model.SipAddress.wrap(item)
          }.toList
        )
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.alexaforbusiness.model.primitives.ClientRequestToken(value)
        )
    override val tags
        : Optional[List[zio.aws.alexaforbusiness.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.alexaforbusiness.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.CreateContactRequest
  ): zio.aws.alexaforbusiness.model.CreateContactRequest.ReadOnly = new Wrapper(
    impl
  )
}
