package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.Arn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AssociateSkillGroupWithRoomRequest(
    skillGroupArn: Optional[Arn] = Optional.Absent,
    roomArn: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.AssociateSkillGroupWithRoomRequest = {
    import AssociateSkillGroupWithRoomRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.AssociateSkillGroupWithRoomRequest
      .builder()
      .optionallyWith(
        skillGroupArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.skillGroupArn)
      .optionallyWith(
        roomArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.roomArn)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.AssociateSkillGroupWithRoomRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.AssociateSkillGroupWithRoomRequest
      .wrap(buildAwsValue())
}
object AssociateSkillGroupWithRoomRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.AssociateSkillGroupWithRoomRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.alexaforbusiness.model.AssociateSkillGroupWithRoomRequest =
      zio.aws.alexaforbusiness.model.AssociateSkillGroupWithRoomRequest(
        skillGroupArn.map(value => value),
        roomArn.map(value => value)
      )
    def skillGroupArn: Optional[Arn]
    def roomArn: Optional[Arn]
    def getSkillGroupArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("skillGroupArn", skillGroupArn)
    def getRoomArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("roomArn", roomArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.AssociateSkillGroupWithRoomRequest
  ) extends zio.aws.alexaforbusiness.model.AssociateSkillGroupWithRoomRequest.ReadOnly {
    override val skillGroupArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.skillGroupArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
    override val roomArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.roomArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.AssociateSkillGroupWithRoomRequest
  ): zio.aws.alexaforbusiness.model.AssociateSkillGroupWithRoomRequest.ReadOnly =
    new Wrapper(impl)
}
