package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.Arn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AssociateDeviceWithRoomRequest(
    deviceArn: Optional[Arn] = Optional.Absent,
    roomArn: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.AssociateDeviceWithRoomRequest = {
    import AssociateDeviceWithRoomRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.AssociateDeviceWithRoomRequest
      .builder()
      .optionallyWith(
        deviceArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.deviceArn)
      .optionallyWith(
        roomArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.roomArn)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.AssociateDeviceWithRoomRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.AssociateDeviceWithRoomRequest
      .wrap(buildAwsValue())
}
object AssociateDeviceWithRoomRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.AssociateDeviceWithRoomRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.alexaforbusiness.model.AssociateDeviceWithRoomRequest =
      zio.aws.alexaforbusiness.model.AssociateDeviceWithRoomRequest(
        deviceArn.map(value => value),
        roomArn.map(value => value)
      )
    def deviceArn: Optional[Arn]
    def roomArn: Optional[Arn]
    def getDeviceArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("deviceArn", deviceArn)
    def getRoomArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("roomArn", roomArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.AssociateDeviceWithRoomRequest
  ) extends zio.aws.alexaforbusiness.model.AssociateDeviceWithRoomRequest.ReadOnly {
    override val deviceArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
    override val roomArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.roomArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.AssociateDeviceWithRoomRequest
  ): zio.aws.alexaforbusiness.model.AssociateDeviceWithRoomRequest.ReadOnly =
    new Wrapper(impl)
}
