package zio.aws.alexaforbusiness.model
import scala.jdk.CollectionConverters._
sealed trait SortValue {
  def unwrap: software.amazon.awssdk.services.alexaforbusiness.model.SortValue
}
object SortValue {
  def wrap(
      value: software.amazon.awssdk.services.alexaforbusiness.model.SortValue
  ): zio.aws.alexaforbusiness.model.SortValue = value match {
    case software.amazon.awssdk.services.alexaforbusiness.model.SortValue.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.SortValue.ASC =>
      val r = ASC
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.SortValue.DESC =>
      val r = DESC
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.alexaforbusiness.model.SortValue {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.SortValue =
      software.amazon.awssdk.services.alexaforbusiness.model.SortValue.UNKNOWN_TO_SDK_VERSION
  }
  case object ASC extends zio.aws.alexaforbusiness.model.SortValue {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.SortValue =
      software.amazon.awssdk.services.alexaforbusiness.model.SortValue.ASC
  }
  case object DESC extends zio.aws.alexaforbusiness.model.SortValue {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.SortValue =
      software.amazon.awssdk.services.alexaforbusiness.model.SortValue.DESC
  }
}
