package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{
  SkillId,
  SkillName,
  ShortDescription,
  IconUrl,
  Utterance
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SkillsStoreSkill(
    skillId: Option[SkillId] = None,
    skillName: Option[SkillName] = None,
    shortDescription: Option[ShortDescription] = None,
    iconUrl: Option[IconUrl] = None,
    sampleUtterances: Option[Iterable[Utterance]] = None,
    skillDetails: Option[zio.aws.alexaforbusiness.model.SkillDetails] = None,
    supportsLinking: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.SkillsStoreSkill = {
    import SkillsStoreSkill.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.SkillsStoreSkill
      .builder()
      .optionallyWith(
        skillId.map(value => SkillId.unwrap(value): java.lang.String)
      )(_.skillId)
      .optionallyWith(
        skillName.map(value => SkillName.unwrap(value): java.lang.String)
      )(_.skillName)
      .optionallyWith(
        shortDescription.map(value =>
          ShortDescription.unwrap(value): java.lang.String
        )
      )(_.shortDescription)
      .optionallyWith(
        iconUrl.map(value => IconUrl.unwrap(value): java.lang.String)
      )(_.iconUrl)
      .optionallyWith(
        sampleUtterances.map(value =>
          value.map { item =>
            Utterance.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.sampleUtterances)
      .optionallyWith(skillDetails.map(value => value.buildAwsValue()))(
        _.skillDetails
      )
      .optionallyWith(supportsLinking.map(value => value: java.lang.Boolean))(
        _.supportsLinking
      )
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.SkillsStoreSkill.ReadOnly =
    zio.aws.alexaforbusiness.model.SkillsStoreSkill.wrap(buildAwsValue())
}
object SkillsStoreSkill {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.SkillsStoreSkill
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.SkillsStoreSkill =
      zio.aws.alexaforbusiness.model.SkillsStoreSkill(
        skillId.map(value => value),
        skillName.map(value => value),
        shortDescription.map(value => value),
        iconUrl.map(value => value),
        sampleUtterances.map(value => value),
        skillDetails.map(value => value.asEditable),
        supportsLinking.map(value => value)
      )
    def skillId: Option[SkillId]
    def skillName: Option[SkillName]
    def shortDescription: Option[ShortDescription]
    def iconUrl: Option[IconUrl]
    def sampleUtterances: Option[List[Utterance]]
    def skillDetails
        : Option[zio.aws.alexaforbusiness.model.SkillDetails.ReadOnly]
    def supportsLinking: Option[Boolean]
    def getSkillId: ZIO[Any, AwsError, SkillId] =
      AwsError.unwrapOptionField("skillId", skillId)
    def getSkillName: ZIO[Any, AwsError, SkillName] =
      AwsError.unwrapOptionField("skillName", skillName)
    def getShortDescription: ZIO[Any, AwsError, ShortDescription] =
      AwsError.unwrapOptionField("shortDescription", shortDescription)
    def getIconUrl: ZIO[Any, AwsError, IconUrl] =
      AwsError.unwrapOptionField("iconUrl", iconUrl)
    def getSampleUtterances: ZIO[Any, AwsError, List[Utterance]] =
      AwsError.unwrapOptionField("sampleUtterances", sampleUtterances)
    def getSkillDetails: ZIO[
      Any,
      AwsError,
      zio.aws.alexaforbusiness.model.SkillDetails.ReadOnly
    ] = AwsError.unwrapOptionField("skillDetails", skillDetails)
    def getSupportsLinking: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("supportsLinking", supportsLinking)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.SkillsStoreSkill
  ) extends zio.aws.alexaforbusiness.model.SkillsStoreSkill.ReadOnly {
    override val skillId: Option[SkillId] = scala
      .Option(impl.skillId())
      .map(value => zio.aws.alexaforbusiness.model.primitives.SkillId(value))
    override val skillName: Option[SkillName] = scala
      .Option(impl.skillName())
      .map(value => zio.aws.alexaforbusiness.model.primitives.SkillName(value))
    override val shortDescription: Option[ShortDescription] = scala
      .Option(impl.shortDescription())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.ShortDescription(value)
      )
    override val iconUrl: Option[IconUrl] = scala
      .Option(impl.iconUrl())
      .map(value => zio.aws.alexaforbusiness.model.primitives.IconUrl(value))
    override val sampleUtterances: Option[List[Utterance]] = scala
      .Option(impl.sampleUtterances())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.alexaforbusiness.model.primitives.Utterance(item)
        }.toList
      )
    override val skillDetails
        : Option[zio.aws.alexaforbusiness.model.SkillDetails.ReadOnly] = scala
      .Option(impl.skillDetails())
      .map(value => zio.aws.alexaforbusiness.model.SkillDetails.wrap(value))
    override val supportsLinking: Option[Boolean] =
      scala.Option(impl.supportsLinking()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.SkillsStoreSkill
  ): zio.aws.alexaforbusiness.model.SkillsStoreSkill.ReadOnly = new Wrapper(
    impl
  )
}
