package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.Arn
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DisassociateDeviceFromRoomRequest(
    deviceArn: Option[Arn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.DisassociateDeviceFromRoomRequest = {
    import DisassociateDeviceFromRoomRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.DisassociateDeviceFromRoomRequest
      .builder()
      .optionallyWith(
        deviceArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.deviceArn)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.DisassociateDeviceFromRoomRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.DisassociateDeviceFromRoomRequest
      .wrap(buildAwsValue())
}
object DisassociateDeviceFromRoomRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.DisassociateDeviceFromRoomRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.alexaforbusiness.model.DisassociateDeviceFromRoomRequest =
      zio.aws.alexaforbusiness.model
        .DisassociateDeviceFromRoomRequest(deviceArn.map(value => value))
    def deviceArn: Option[Arn]
    def getDeviceArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("deviceArn", deviceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.DisassociateDeviceFromRoomRequest
  ) extends zio.aws.alexaforbusiness.model.DisassociateDeviceFromRoomRequest.ReadOnly {
    override val deviceArn: Option[Arn] = scala
      .Option(impl.deviceArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.DisassociateDeviceFromRoomRequest
  ): zio.aws.alexaforbusiness.model.DisassociateDeviceFromRoomRequest.ReadOnly =
    new Wrapper(impl)
}
