package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{CertificateTime, Arn}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DeviceNetworkProfileInfo(
    networkProfileArn: Option[Arn] = None,
    certificateArn: Option[Arn] = None,
    certificateExpirationTime: Option[CertificateTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.DeviceNetworkProfileInfo = {
    import DeviceNetworkProfileInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.DeviceNetworkProfileInfo
      .builder()
      .optionallyWith(
        networkProfileArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.networkProfileArn)
      .optionallyWith(
        certificateArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.certificateArn)
      .optionallyWith(
        certificateExpirationTime.map(value =>
          CertificateTime.unwrap(value): Instant
        )
      )(_.certificateExpirationTime)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.DeviceNetworkProfileInfo.ReadOnly =
    zio.aws.alexaforbusiness.model.DeviceNetworkProfileInfo
      .wrap(buildAwsValue())
}
object DeviceNetworkProfileInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.DeviceNetworkProfileInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.DeviceNetworkProfileInfo =
      zio.aws.alexaforbusiness.model.DeviceNetworkProfileInfo(
        networkProfileArn.map(value => value),
        certificateArn.map(value => value),
        certificateExpirationTime.map(value => value)
      )
    def networkProfileArn: Option[Arn]
    def certificateArn: Option[Arn]
    def certificateExpirationTime: Option[CertificateTime]
    def getNetworkProfileArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("networkProfileArn", networkProfileArn)
    def getCertificateArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("certificateArn", certificateArn)
    def getCertificateExpirationTime: ZIO[Any, AwsError, CertificateTime] =
      AwsError.unwrapOptionField(
        "certificateExpirationTime",
        certificateExpirationTime
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.DeviceNetworkProfileInfo
  ) extends zio.aws.alexaforbusiness.model.DeviceNetworkProfileInfo.ReadOnly {
    override val networkProfileArn: Option[Arn] = scala
      .Option(impl.networkProfileArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
    override val certificateArn: Option[Arn] = scala
      .Option(impl.certificateArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
    override val certificateExpirationTime: Option[CertificateTime] = scala
      .Option(impl.certificateExpirationTime())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.CertificateTime(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.DeviceNetworkProfileInfo
  ): zio.aws.alexaforbusiness.model.DeviceNetworkProfileInfo.ReadOnly =
    new Wrapper(impl)
}
