package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{EnrollmentId, Arn}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteUserRequest(
    userArn: Option[Arn] = None,
    enrollmentId: EnrollmentId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.DeleteUserRequest = {
    import DeleteUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.DeleteUserRequest
      .builder()
      .optionallyWith(
        userArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.userArn)
      .enrollmentId(EnrollmentId.unwrap(enrollmentId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.DeleteUserRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.DeleteUserRequest.wrap(buildAwsValue())
}
object DeleteUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.DeleteUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.DeleteUserRequest =
      zio.aws.alexaforbusiness.model
        .DeleteUserRequest(userArn.map(value => value), enrollmentId)
    def userArn: Option[Arn]
    def enrollmentId: EnrollmentId
    def getUserArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("userArn", userArn)
    def getEnrollmentId: ZIO[Any, Nothing, EnrollmentId] =
      ZIO.succeed(enrollmentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.DeleteUserRequest
  ) extends zio.aws.alexaforbusiness.model.DeleteUserRequest.ReadOnly {
    override val userArn: Option[Arn] = scala
      .Option(impl.userArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
    override val enrollmentId: EnrollmentId =
      zio.aws.alexaforbusiness.model.primitives
        .EnrollmentId(impl.enrollmentId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.DeleteUserRequest
  ): zio.aws.alexaforbusiness.model.DeleteUserRequest.ReadOnly = new Wrapper(
    impl
  )
}
