package zio.aws.alexaforbusiness.model
import java.lang.Integer
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.Minutes
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InstantBooking(
    durationInMinutes: Option[Minutes] = None,
    enabled: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.InstantBooking = {
    import InstantBooking.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.InstantBooking
      .builder()
      .optionallyWith(
        durationInMinutes.map(value => Minutes.unwrap(value): Integer)
      )(_.durationInMinutes)
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.InstantBooking.ReadOnly =
    zio.aws.alexaforbusiness.model.InstantBooking.wrap(buildAwsValue())
}
object InstantBooking {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.InstantBooking
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.InstantBooking =
      zio.aws.alexaforbusiness.model.InstantBooking(
        durationInMinutes.map(value => value),
        enabled.map(value => value)
      )
    def durationInMinutes: Option[Minutes]
    def enabled: Option[Boolean]
    def getDurationInMinutes: ZIO[Any, AwsError, Minutes] =
      AwsError.unwrapOptionField("durationInMinutes", durationInMinutes)
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.InstantBooking
  ) extends zio.aws.alexaforbusiness.model.InstantBooking.ReadOnly {
    override val durationInMinutes: Option[Minutes] = scala
      .Option(impl.durationInMinutes())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Minutes(value))
    override val enabled: Option[Boolean] =
      scala.Option(impl.enabled()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.InstantBooking
  ): zio.aws.alexaforbusiness.model.InstantBooking.ReadOnly = new Wrapper(impl)
}
