package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.Arn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AssociateDeviceWithNetworkProfileRequest(
    deviceArn: Arn,
    networkProfileArn: Arn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.AssociateDeviceWithNetworkProfileRequest = {
    import AssociateDeviceWithNetworkProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.AssociateDeviceWithNetworkProfileRequest
      .builder()
      .deviceArn(Arn.unwrap(deviceArn): java.lang.String)
      .networkProfileArn(Arn.unwrap(networkProfileArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.AssociateDeviceWithNetworkProfileRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.AssociateDeviceWithNetworkProfileRequest
      .wrap(buildAwsValue())
}
object AssociateDeviceWithNetworkProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.AssociateDeviceWithNetworkProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.alexaforbusiness.model.AssociateDeviceWithNetworkProfileRequest =
      zio.aws.alexaforbusiness.model
        .AssociateDeviceWithNetworkProfileRequest(deviceArn, networkProfileArn)
    def deviceArn: Arn
    def networkProfileArn: Arn
    def getDeviceArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(deviceArn)
    def getNetworkProfileArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(networkProfileArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.AssociateDeviceWithNetworkProfileRequest
  ) extends zio.aws.alexaforbusiness.model.AssociateDeviceWithNetworkProfileRequest.ReadOnly {
    override val deviceArn: Arn =
      zio.aws.alexaforbusiness.model.primitives.Arn(impl.deviceArn())
    override val networkProfileArn: Arn =
      zio.aws.alexaforbusiness.model.primitives.Arn(impl.networkProfileArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.AssociateDeviceWithNetworkProfileRequest
  ): zio.aws.alexaforbusiness.model.AssociateDeviceWithNetworkProfileRequest.ReadOnly =
    new Wrapper(impl)
}
