package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{
  RawPhoneNumber,
  ContactName,
  Arn
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateContactRequest(
    contactArn: Arn,
    displayName: Option[ContactName] = None,
    firstName: Option[ContactName] = None,
    lastName: Option[ContactName] = None,
    phoneNumber: Option[RawPhoneNumber] = None,
    phoneNumbers: Option[Iterable[zio.aws.alexaforbusiness.model.PhoneNumber]] =
      None,
    sipAddresses: Option[Iterable[zio.aws.alexaforbusiness.model.SipAddress]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.UpdateContactRequest = {
    import UpdateContactRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.UpdateContactRequest
      .builder()
      .contactArn(Arn.unwrap(contactArn): java.lang.String)
      .optionallyWith(
        displayName.map(value => ContactName.unwrap(value): java.lang.String)
      )(_.displayName)
      .optionallyWith(
        firstName.map(value => ContactName.unwrap(value): java.lang.String)
      )(_.firstName)
      .optionallyWith(
        lastName.map(value => ContactName.unwrap(value): java.lang.String)
      )(_.lastName)
      .optionallyWith(
        phoneNumber.map(value => RawPhoneNumber.unwrap(value): java.lang.String)
      )(_.phoneNumber)
      .optionallyWith(
        phoneNumbers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.phoneNumbers)
      .optionallyWith(
        sipAddresses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sipAddresses)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.UpdateContactRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.UpdateContactRequest.wrap(buildAwsValue())
}
object UpdateContactRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.UpdateContactRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.UpdateContactRequest =
      zio.aws.alexaforbusiness.model.UpdateContactRequest(
        contactArn,
        displayName.map(value => value),
        firstName.map(value => value),
        lastName.map(value => value),
        phoneNumber.map(value => value),
        phoneNumbers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sipAddresses.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def contactArn: Arn
    def displayName: Option[ContactName]
    def firstName: Option[ContactName]
    def lastName: Option[ContactName]
    def phoneNumber: Option[RawPhoneNumber]
    def phoneNumbers
        : Option[List[zio.aws.alexaforbusiness.model.PhoneNumber.ReadOnly]]
    def sipAddresses
        : Option[List[zio.aws.alexaforbusiness.model.SipAddress.ReadOnly]]
    def getContactArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(contactArn)
    def getDisplayName: ZIO[Any, AwsError, ContactName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getFirstName: ZIO[Any, AwsError, ContactName] =
      AwsError.unwrapOptionField("firstName", firstName)
    def getLastName: ZIO[Any, AwsError, ContactName] =
      AwsError.unwrapOptionField("lastName", lastName)
    def getPhoneNumber: ZIO[Any, AwsError, RawPhoneNumber] =
      AwsError.unwrapOptionField("phoneNumber", phoneNumber)
    def getPhoneNumbers: ZIO[Any, AwsError, List[
      zio.aws.alexaforbusiness.model.PhoneNumber.ReadOnly
    ]] = AwsError.unwrapOptionField("phoneNumbers", phoneNumbers)
    def getSipAddresses: ZIO[Any, AwsError, List[
      zio.aws.alexaforbusiness.model.SipAddress.ReadOnly
    ]] = AwsError.unwrapOptionField("sipAddresses", sipAddresses)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.UpdateContactRequest
  ) extends zio.aws.alexaforbusiness.model.UpdateContactRequest.ReadOnly {
    override val contactArn: Arn =
      zio.aws.alexaforbusiness.model.primitives.Arn(impl.contactArn())
    override val displayName: Option[ContactName] = scala
      .Option(impl.displayName())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.ContactName(value)
      )
    override val firstName: Option[ContactName] = scala
      .Option(impl.firstName())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.ContactName(value)
      )
    override val lastName: Option[ContactName] = scala
      .Option(impl.lastName())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.ContactName(value)
      )
    override val phoneNumber: Option[RawPhoneNumber] = scala
      .Option(impl.phoneNumber())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.RawPhoneNumber(value)
      )
    override val phoneNumbers
        : Option[List[zio.aws.alexaforbusiness.model.PhoneNumber.ReadOnly]] =
      scala
        .Option(impl.phoneNumbers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.alexaforbusiness.model.PhoneNumber.wrap(item)
          }.toList
        )
    override val sipAddresses
        : Option[List[zio.aws.alexaforbusiness.model.SipAddress.ReadOnly]] =
      scala
        .Option(impl.sipAddresses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.alexaforbusiness.model.SipAddress.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.UpdateContactRequest
  ): zio.aws.alexaforbusiness.model.UpdateContactRequest.ReadOnly = new Wrapper(
    impl
  )
}
