package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.Arn
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StartDeviceSyncRequest(
    roomArn: Option[Arn] = None,
    deviceArn: Option[Arn] = None,
    features: Iterable[zio.aws.alexaforbusiness.model.Feature]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.StartDeviceSyncRequest = {
    import StartDeviceSyncRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.StartDeviceSyncRequest
      .builder()
      .optionallyWith(
        roomArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.roomArn)
      .optionallyWith(
        deviceArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.deviceArn)
      .featuresWithStrings(features.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.StartDeviceSyncRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.StartDeviceSyncRequest.wrap(buildAwsValue())
}
object StartDeviceSyncRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.StartDeviceSyncRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.StartDeviceSyncRequest =
      zio.aws.alexaforbusiness.model.StartDeviceSyncRequest(
        roomArn.map(value => value),
        deviceArn.map(value => value),
        features
      )
    def roomArn: Option[Arn]
    def deviceArn: Option[Arn]
    def features: List[zio.aws.alexaforbusiness.model.Feature]
    def getRoomArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("roomArn", roomArn)
    def getDeviceArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("deviceArn", deviceArn)
    def getFeatures
        : ZIO[Any, Nothing, List[zio.aws.alexaforbusiness.model.Feature]] =
      ZIO.succeed(features)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.StartDeviceSyncRequest
  ) extends zio.aws.alexaforbusiness.model.StartDeviceSyncRequest.ReadOnly {
    override val roomArn: Option[Arn] = scala
      .Option(impl.roomArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
    override val deviceArn: Option[Arn] = scala
      .Option(impl.deviceArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
    override val features: List[zio.aws.alexaforbusiness.model.Feature] = impl
      .features()
      .asScala
      .map { item =>
        zio.aws.alexaforbusiness.model.Feature.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.StartDeviceSyncRequest
  ): zio.aws.alexaforbusiness.model.StartDeviceSyncRequest.ReadOnly =
    new Wrapper(impl)
}
