package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.Arn
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SendAnnouncementResponse(announcementArn: Option[Arn] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.SendAnnouncementResponse = {
    import SendAnnouncementResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.SendAnnouncementResponse
      .builder()
      .optionallyWith(
        announcementArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.announcementArn)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.SendAnnouncementResponse.ReadOnly =
    zio.aws.alexaforbusiness.model.SendAnnouncementResponse
      .wrap(buildAwsValue())
}
object SendAnnouncementResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.SendAnnouncementResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.SendAnnouncementResponse =
      zio.aws.alexaforbusiness.model
        .SendAnnouncementResponse(announcementArn.map(value => value))
    def announcementArn: Option[Arn]
    def getAnnouncementArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("announcementArn", announcementArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.SendAnnouncementResponse
  ) extends zio.aws.alexaforbusiness.model.SendAnnouncementResponse.ReadOnly {
    override val announcementArn: Option[Arn] = scala
      .Option(impl.announcementArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.SendAnnouncementResponse
  ): zio.aws.alexaforbusiness.model.SendAnnouncementResponse.ReadOnly =
    new Wrapper(impl)
}
