package zio.aws.alexaforbusiness.model
import java.lang.Integer
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{
  ClientRequestToken,
  TimeToLiveInSeconds
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SendAnnouncementRequest(
    roomFilters: Iterable[zio.aws.alexaforbusiness.model.Filter],
    content: zio.aws.alexaforbusiness.model.Content,
    timeToLiveInSeconds: Option[TimeToLiveInSeconds] = None,
    clientRequestToken: ClientRequestToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.SendAnnouncementRequest = {
    import SendAnnouncementRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.SendAnnouncementRequest
      .builder()
      .roomFilters(roomFilters.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .content(content.buildAwsValue())
      .optionallyWith(
        timeToLiveInSeconds.map(value =>
          TimeToLiveInSeconds.unwrap(value): Integer
        )
      )(_.timeToLiveInSeconds)
      .clientRequestToken(
        ClientRequestToken.unwrap(clientRequestToken): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.SendAnnouncementRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.SendAnnouncementRequest.wrap(buildAwsValue())
}
object SendAnnouncementRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.SendAnnouncementRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.SendAnnouncementRequest =
      zio.aws.alexaforbusiness.model.SendAnnouncementRequest(
        roomFilters.map { item =>
          item.asEditable
        },
        content.asEditable,
        timeToLiveInSeconds.map(value => value),
        clientRequestToken
      )
    def roomFilters: List[zio.aws.alexaforbusiness.model.Filter.ReadOnly]
    def content: zio.aws.alexaforbusiness.model.Content.ReadOnly
    def timeToLiveInSeconds: Option[TimeToLiveInSeconds]
    def clientRequestToken: ClientRequestToken
    def getRoomFilters: ZIO[Any, Nothing, List[
      zio.aws.alexaforbusiness.model.Filter.ReadOnly
    ]] = ZIO.succeed(roomFilters)
    def getContent
        : ZIO[Any, Nothing, zio.aws.alexaforbusiness.model.Content.ReadOnly] =
      ZIO.succeed(content)
    def getTimeToLiveInSeconds: ZIO[Any, AwsError, TimeToLiveInSeconds] =
      AwsError.unwrapOptionField("timeToLiveInSeconds", timeToLiveInSeconds)
    def getClientRequestToken: ZIO[Any, Nothing, ClientRequestToken] =
      ZIO.succeed(clientRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.SendAnnouncementRequest
  ) extends zio.aws.alexaforbusiness.model.SendAnnouncementRequest.ReadOnly {
    override val roomFilters
        : List[zio.aws.alexaforbusiness.model.Filter.ReadOnly] = impl
      .roomFilters()
      .asScala
      .map { item =>
        zio.aws.alexaforbusiness.model.Filter.wrap(item)
      }
      .toList
    override val content: zio.aws.alexaforbusiness.model.Content.ReadOnly =
      zio.aws.alexaforbusiness.model.Content.wrap(impl.content())
    override val timeToLiveInSeconds: Option[TimeToLiveInSeconds] = scala
      .Option(impl.timeToLiveInSeconds())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.TimeToLiveInSeconds(value)
      )
    override val clientRequestToken: ClientRequestToken =
      zio.aws.alexaforbusiness.model.primitives
        .ClientRequestToken(impl.clientRequestToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.SendAnnouncementRequest
  ): zio.aws.alexaforbusiness.model.SendAnnouncementRequest.ReadOnly =
    new Wrapper(impl)
}
