package zio.aws.alexaforbusiness.model
import java.lang.Integer
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{TotalCount, NextToken}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SearchSkillGroupsResponse(
    skillGroups: Option[
      Iterable[zio.aws.alexaforbusiness.model.SkillGroupData]
    ] = None,
    nextToken: Option[NextToken] = None,
    totalCount: Option[TotalCount] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.SearchSkillGroupsResponse = {
    import SearchSkillGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.SearchSkillGroupsResponse
      .builder()
      .optionallyWith(
        skillGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.skillGroups)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        totalCount.map(value => TotalCount.unwrap(value): Integer)
      )(_.totalCount)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.SearchSkillGroupsResponse.ReadOnly =
    zio.aws.alexaforbusiness.model.SearchSkillGroupsResponse
      .wrap(buildAwsValue())
}
object SearchSkillGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.SearchSkillGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.SearchSkillGroupsResponse =
      zio.aws.alexaforbusiness.model.SearchSkillGroupsResponse(
        skillGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        totalCount.map(value => value)
      )
    def skillGroups
        : Option[List[zio.aws.alexaforbusiness.model.SkillGroupData.ReadOnly]]
    def nextToken: Option[NextToken]
    def totalCount: Option[TotalCount]
    def getSkillGroups: ZIO[Any, AwsError, List[
      zio.aws.alexaforbusiness.model.SkillGroupData.ReadOnly
    ]] = AwsError.unwrapOptionField("skillGroups", skillGroups)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getTotalCount: ZIO[Any, AwsError, TotalCount] =
      AwsError.unwrapOptionField("totalCount", totalCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.SearchSkillGroupsResponse
  ) extends zio.aws.alexaforbusiness.model.SearchSkillGroupsResponse.ReadOnly {
    override val skillGroups
        : Option[List[zio.aws.alexaforbusiness.model.SkillGroupData.ReadOnly]] =
      scala
        .Option(impl.skillGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.alexaforbusiness.model.SkillGroupData.wrap(item)
          }.toList
        )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.alexaforbusiness.model.primitives.NextToken(value))
    override val totalCount: Option[TotalCount] = scala
      .Option(impl.totalCount())
      .map(value => zio.aws.alexaforbusiness.model.primitives.TotalCount(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.SearchSkillGroupsResponse
  ): zio.aws.alexaforbusiness.model.SearchSkillGroupsResponse.ReadOnly =
    new Wrapper(impl)
}
