package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{RoomName, Arn}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ResolveRoomResponse(
    roomArn: Option[Arn] = None,
    roomName: Option[RoomName] = None,
    roomSkillParameters: Option[
      Iterable[zio.aws.alexaforbusiness.model.RoomSkillParameter]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.ResolveRoomResponse = {
    import ResolveRoomResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.ResolveRoomResponse
      .builder()
      .optionallyWith(
        roomArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.roomArn)
      .optionallyWith(
        roomName.map(value => RoomName.unwrap(value): java.lang.String)
      )(_.roomName)
      .optionallyWith(
        roomSkillParameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.roomSkillParameters)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.ResolveRoomResponse.ReadOnly =
    zio.aws.alexaforbusiness.model.ResolveRoomResponse.wrap(buildAwsValue())
}
object ResolveRoomResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.ResolveRoomResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.ResolveRoomResponse =
      zio.aws.alexaforbusiness.model.ResolveRoomResponse(
        roomArn.map(value => value),
        roomName.map(value => value),
        roomSkillParameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def roomArn: Option[Arn]
    def roomName: Option[RoomName]
    def roomSkillParameters: Option[
      List[zio.aws.alexaforbusiness.model.RoomSkillParameter.ReadOnly]
    ]
    def getRoomArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("roomArn", roomArn)
    def getRoomName: ZIO[Any, AwsError, RoomName] =
      AwsError.unwrapOptionField("roomName", roomName)
    def getRoomSkillParameters: ZIO[Any, AwsError, List[
      zio.aws.alexaforbusiness.model.RoomSkillParameter.ReadOnly
    ]] = AwsError.unwrapOptionField("roomSkillParameters", roomSkillParameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.ResolveRoomResponse
  ) extends zio.aws.alexaforbusiness.model.ResolveRoomResponse.ReadOnly {
    override val roomArn: Option[Arn] = scala
      .Option(impl.roomArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
    override val roomName: Option[RoomName] = scala
      .Option(impl.roomName())
      .map(value => zio.aws.alexaforbusiness.model.primitives.RoomName(value))
    override val roomSkillParameters: Option[
      List[zio.aws.alexaforbusiness.model.RoomSkillParameter.ReadOnly]
    ] = scala
      .Option(impl.roomSkillParameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.alexaforbusiness.model.RoomSkillParameter.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.ResolveRoomResponse
  ): zio.aws.alexaforbusiness.model.ResolveRoomResponse.ReadOnly = new Wrapper(
    impl
  )
}
