package zio.aws.alexaforbusiness.model
import java.lang.Integer
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.Minutes
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RequireCheckIn(
    releaseAfterMinutes: Option[Minutes] = None,
    enabled: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.RequireCheckIn = {
    import RequireCheckIn.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.RequireCheckIn
      .builder()
      .optionallyWith(
        releaseAfterMinutes.map(value => Minutes.unwrap(value): Integer)
      )(_.releaseAfterMinutes)
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.RequireCheckIn.ReadOnly =
    zio.aws.alexaforbusiness.model.RequireCheckIn.wrap(buildAwsValue())
}
object RequireCheckIn {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.RequireCheckIn
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.RequireCheckIn =
      zio.aws.alexaforbusiness.model.RequireCheckIn(
        releaseAfterMinutes.map(value => value),
        enabled.map(value => value)
      )
    def releaseAfterMinutes: Option[Minutes]
    def enabled: Option[Boolean]
    def getReleaseAfterMinutes: ZIO[Any, AwsError, Minutes] =
      AwsError.unwrapOptionField("releaseAfterMinutes", releaseAfterMinutes)
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.RequireCheckIn
  ) extends zio.aws.alexaforbusiness.model.RequireCheckIn.ReadOnly {
    override val releaseAfterMinutes: Option[Minutes] = scala
      .Option(impl.releaseAfterMinutes())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Minutes(value))
    override val enabled: Option[Boolean] =
      scala.Option(impl.enabled()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.RequireCheckIn
  ): zio.aws.alexaforbusiness.model.RequireCheckIn.ReadOnly = new Wrapper(impl)
}
