package zio.aws.alexaforbusiness.model
import java.lang.Integer
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{
  SkillListMaxResults,
  NextToken,
  CategoryId
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListSkillsStoreSkillsByCategoryRequest(
    categoryId: CategoryId,
    nextToken: Option[NextToken] = None,
    maxResults: Option[SkillListMaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreSkillsByCategoryRequest = {
    import ListSkillsStoreSkillsByCategoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreSkillsByCategoryRequest
      .builder()
      .categoryId(CategoryId.unwrap(categoryId): java.lang.Long)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => SkillListMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.ListSkillsStoreSkillsByCategoryRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.ListSkillsStoreSkillsByCategoryRequest
      .wrap(buildAwsValue())
}
object ListSkillsStoreSkillsByCategoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreSkillsByCategoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.alexaforbusiness.model.ListSkillsStoreSkillsByCategoryRequest =
      zio.aws.alexaforbusiness.model.ListSkillsStoreSkillsByCategoryRequest(
        categoryId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def categoryId: CategoryId
    def nextToken: Option[NextToken]
    def maxResults: Option[SkillListMaxResults]
    def getCategoryId: ZIO[Any, Nothing, CategoryId] = ZIO.succeed(categoryId)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, SkillListMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreSkillsByCategoryRequest
  ) extends zio.aws.alexaforbusiness.model.ListSkillsStoreSkillsByCategoryRequest.ReadOnly {
    override val categoryId: CategoryId =
      zio.aws.alexaforbusiness.model.primitives.CategoryId(impl.categoryId())
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.alexaforbusiness.model.primitives.NextToken(value))
    override val maxResults: Option[SkillListMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.SkillListMaxResults(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreSkillsByCategoryRequest
  ): zio.aws.alexaforbusiness.model.ListSkillsStoreSkillsByCategoryRequest.ReadOnly =
    new Wrapper(impl)
}
