package zio.aws.alexaforbusiness.model
import java.lang.Integer
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{MaxResults, NextToken}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListConferenceProvidersRequest(
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.ListConferenceProvidersRequest = {
    import ListConferenceProvidersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.ListConferenceProvidersRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.ListConferenceProvidersRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.ListConferenceProvidersRequest
      .wrap(buildAwsValue())
}
object ListConferenceProvidersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.ListConferenceProvidersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.alexaforbusiness.model.ListConferenceProvidersRequest =
      zio.aws.alexaforbusiness.model.ListConferenceProvidersRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.ListConferenceProvidersRequest
  ) extends zio.aws.alexaforbusiness.model.ListConferenceProvidersRequest.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.alexaforbusiness.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.alexaforbusiness.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.ListConferenceProvidersRequest
  ): zio.aws.alexaforbusiness.model.ListConferenceProvidersRequest.ReadOnly =
    new Wrapper(impl)
}
