package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.Arn
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetSkillGroupRequest(skillGroupArn: Option[Arn] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.GetSkillGroupRequest = {
    import GetSkillGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.GetSkillGroupRequest
      .builder()
      .optionallyWith(
        skillGroupArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.skillGroupArn)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.GetSkillGroupRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.GetSkillGroupRequest.wrap(buildAwsValue())
}
object GetSkillGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.GetSkillGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.GetSkillGroupRequest =
      zio.aws.alexaforbusiness.model
        .GetSkillGroupRequest(skillGroupArn.map(value => value))
    def skillGroupArn: Option[Arn]
    def getSkillGroupArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("skillGroupArn", skillGroupArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.GetSkillGroupRequest
  ) extends zio.aws.alexaforbusiness.model.GetSkillGroupRequest.ReadOnly {
    override val skillGroupArn: Option[Arn] = scala
      .Option(impl.skillGroupArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.GetSkillGroupRequest
  ): zio.aws.alexaforbusiness.model.GetSkillGroupRequest.ReadOnly = new Wrapper(
    impl
  )
}
