package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetGatewayGroupResponse(
    gatewayGroup: Option[zio.aws.alexaforbusiness.model.GatewayGroup] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.GetGatewayGroupResponse = {
    import GetGatewayGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.GetGatewayGroupResponse
      .builder()
      .optionallyWith(gatewayGroup.map(value => value.buildAwsValue()))(
        _.gatewayGroup
      )
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.GetGatewayGroupResponse.ReadOnly =
    zio.aws.alexaforbusiness.model.GetGatewayGroupResponse.wrap(buildAwsValue())
}
object GetGatewayGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.GetGatewayGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.GetGatewayGroupResponse =
      zio.aws.alexaforbusiness.model
        .GetGatewayGroupResponse(gatewayGroup.map(value => value.asEditable))
    def gatewayGroup
        : Option[zio.aws.alexaforbusiness.model.GatewayGroup.ReadOnly]
    def getGatewayGroup: ZIO[
      Any,
      AwsError,
      zio.aws.alexaforbusiness.model.GatewayGroup.ReadOnly
    ] = AwsError.unwrapOptionField("gatewayGroup", gatewayGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.GetGatewayGroupResponse
  ) extends zio.aws.alexaforbusiness.model.GetGatewayGroupResponse.ReadOnly {
    override val gatewayGroup
        : Option[zio.aws.alexaforbusiness.model.GatewayGroup.ReadOnly] = scala
      .Option(impl.gatewayGroup())
      .map(value => zio.aws.alexaforbusiness.model.GatewayGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.GetGatewayGroupResponse
  ): zio.aws.alexaforbusiness.model.GetGatewayGroupResponse.ReadOnly =
    new Wrapper(impl)
}
