package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{
  GatewayVersion,
  GatewayDescription,
  GatewayName,
  Arn
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Gateway(
    arn: Option[Arn] = None,
    name: Option[GatewayName] = None,
    description: Option[GatewayDescription] = None,
    gatewayGroupArn: Option[Arn] = None,
    softwareVersion: Option[GatewayVersion] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.Gateway = {
    import Gateway.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.Gateway
      .builder()
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        name.map(value => GatewayName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          GatewayDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        gatewayGroupArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.gatewayGroupArn)
      .optionallyWith(
        softwareVersion.map(value =>
          GatewayVersion.unwrap(value): java.lang.String
        )
      )(_.softwareVersion)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.Gateway.ReadOnly =
    zio.aws.alexaforbusiness.model.Gateway.wrap(buildAwsValue())
}
object Gateway {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.Gateway
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.Gateway =
      zio.aws.alexaforbusiness.model.Gateway(
        arn.map(value => value),
        name.map(value => value),
        description.map(value => value),
        gatewayGroupArn.map(value => value),
        softwareVersion.map(value => value)
      )
    def arn: Option[Arn]
    def name: Option[GatewayName]
    def description: Option[GatewayDescription]
    def gatewayGroupArn: Option[Arn]
    def softwareVersion: Option[GatewayVersion]
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, GatewayName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, GatewayDescription] =
      AwsError.unwrapOptionField("description", description)
    def getGatewayGroupArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("gatewayGroupArn", gatewayGroupArn)
    def getSoftwareVersion: ZIO[Any, AwsError, GatewayVersion] =
      AwsError.unwrapOptionField("softwareVersion", softwareVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.Gateway
  ) extends zio.aws.alexaforbusiness.model.Gateway.ReadOnly {
    override val arn: Option[Arn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
    override val name: Option[GatewayName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.GatewayName(value)
      )
    override val description: Option[GatewayDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.GatewayDescription(value)
      )
    override val gatewayGroupArn: Option[Arn] = scala
      .Option(impl.gatewayGroupArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
    override val softwareVersion: Option[GatewayVersion] = scala
      .Option(impl.softwareVersion())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.GatewayVersion(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.Gateway
  ): zio.aws.alexaforbusiness.model.Gateway.ReadOnly = new Wrapper(impl)
}
