package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{SkillId, Arn}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DisassociateSkillFromSkillGroupRequest(
    skillGroupArn: Option[Arn] = None,
    skillId: SkillId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.DisassociateSkillFromSkillGroupRequest = {
    import DisassociateSkillFromSkillGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.DisassociateSkillFromSkillGroupRequest
      .builder()
      .optionallyWith(
        skillGroupArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.skillGroupArn)
      .skillId(SkillId.unwrap(skillId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.DisassociateSkillFromSkillGroupRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.DisassociateSkillFromSkillGroupRequest
      .wrap(buildAwsValue())
}
object DisassociateSkillFromSkillGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.DisassociateSkillFromSkillGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.alexaforbusiness.model.DisassociateSkillFromSkillGroupRequest =
      zio.aws.alexaforbusiness.model.DisassociateSkillFromSkillGroupRequest(
        skillGroupArn.map(value => value),
        skillId
      )
    def skillGroupArn: Option[Arn]
    def skillId: SkillId
    def getSkillGroupArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("skillGroupArn", skillGroupArn)
    def getSkillId: ZIO[Any, Nothing, SkillId] = ZIO.succeed(skillId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.DisassociateSkillFromSkillGroupRequest
  ) extends zio.aws.alexaforbusiness.model.DisassociateSkillFromSkillGroupRequest.ReadOnly {
    override val skillGroupArn: Option[Arn] = scala
      .Option(impl.skillGroupArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
    override val skillId: SkillId =
      zio.aws.alexaforbusiness.model.primitives.SkillId(impl.skillId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.DisassociateSkillFromSkillGroupRequest
  ): zio.aws.alexaforbusiness.model.DisassociateSkillFromSkillGroupRequest.ReadOnly =
    new Wrapper(impl)
}
