package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{
  DeviceEventTime,
  DeviceEventValue
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DeviceEvent(
    `type`: Option[zio.aws.alexaforbusiness.model.DeviceEventType] = None,
    value: Option[DeviceEventValue] = None,
    timestamp: Option[DeviceEventTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.DeviceEvent = {
    import DeviceEvent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.DeviceEvent
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        value.map(value => DeviceEventValue.unwrap(value): java.lang.String)
      )(_.value)
      .optionallyWith(
        timestamp.map(value => DeviceEventTime.unwrap(value): Instant)
      )(_.timestamp)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.DeviceEvent.ReadOnly =
    zio.aws.alexaforbusiness.model.DeviceEvent.wrap(buildAwsValue())
}
object DeviceEvent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.DeviceEvent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.DeviceEvent =
      zio.aws.alexaforbusiness.model.DeviceEvent(
        `type`.map(value => value),
        value.map(value => value),
        timestamp.map(value => value)
      )
    def `type`: Option[zio.aws.alexaforbusiness.model.DeviceEventType]
    def value: Option[DeviceEventValue]
    def timestamp: Option[DeviceEventTime]
    def getType
        : ZIO[Any, AwsError, zio.aws.alexaforbusiness.model.DeviceEventType] =
      AwsError.unwrapOptionField("type", `type`)
    def getValue: ZIO[Any, AwsError, DeviceEventValue] =
      AwsError.unwrapOptionField("value", value)
    def getTimestamp: ZIO[Any, AwsError, DeviceEventTime] =
      AwsError.unwrapOptionField("timestamp", timestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.DeviceEvent
  ) extends zio.aws.alexaforbusiness.model.DeviceEvent.ReadOnly {
    override val `type`
        : Option[zio.aws.alexaforbusiness.model.DeviceEventType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.alexaforbusiness.model.DeviceEventType.wrap(value))
    override val value: Option[DeviceEventValue] = scala
      .Option(impl.value())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.DeviceEventValue(value)
      )
    override val timestamp: Option[DeviceEventTime] = scala
      .Option(impl.timestamp())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.DeviceEventTime(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.DeviceEvent
  ): zio.aws.alexaforbusiness.model.DeviceEvent.ReadOnly = new Wrapper(impl)
}
