package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{
  Url,
  Email,
  PrivacyPolicy,
  DeveloperName
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeveloperInfo(
    developerName: Option[DeveloperName] = None,
    privacyPolicy: Option[PrivacyPolicy] = None,
    email: Option[Email] = None,
    url: Option[Url] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.DeveloperInfo = {
    import DeveloperInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.DeveloperInfo
      .builder()
      .optionallyWith(
        developerName.map(value =>
          DeveloperName.unwrap(value): java.lang.String
        )
      )(_.developerName)
      .optionallyWith(
        privacyPolicy.map(value =>
          PrivacyPolicy.unwrap(value): java.lang.String
        )
      )(_.privacyPolicy)
      .optionallyWith(
        email.map(value => Email.unwrap(value): java.lang.String)
      )(_.email)
      .optionallyWith(url.map(value => Url.unwrap(value): java.lang.String))(
        _.url
      )
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.DeveloperInfo.ReadOnly =
    zio.aws.alexaforbusiness.model.DeveloperInfo.wrap(buildAwsValue())
}
object DeveloperInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.DeveloperInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.DeveloperInfo =
      zio.aws.alexaforbusiness.model.DeveloperInfo(
        developerName.map(value => value),
        privacyPolicy.map(value => value),
        email.map(value => value),
        url.map(value => value)
      )
    def developerName: Option[DeveloperName]
    def privacyPolicy: Option[PrivacyPolicy]
    def email: Option[Email]
    def url: Option[Url]
    def getDeveloperName: ZIO[Any, AwsError, DeveloperName] =
      AwsError.unwrapOptionField("developerName", developerName)
    def getPrivacyPolicy: ZIO[Any, AwsError, PrivacyPolicy] =
      AwsError.unwrapOptionField("privacyPolicy", privacyPolicy)
    def getEmail: ZIO[Any, AwsError, Email] =
      AwsError.unwrapOptionField("email", email)
    def getUrl: ZIO[Any, AwsError, Url] = AwsError.unwrapOptionField("url", url)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.DeveloperInfo
  ) extends zio.aws.alexaforbusiness.model.DeveloperInfo.ReadOnly {
    override val developerName: Option[DeveloperName] = scala
      .Option(impl.developerName())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.DeveloperName(value)
      )
    override val privacyPolicy: Option[PrivacyPolicy] = scala
      .Option(impl.privacyPolicy())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.PrivacyPolicy(value)
      )
    override val email: Option[Email] = scala
      .Option(impl.email())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Email(value))
    override val url: Option[Url] = scala
      .Option(impl.url())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Url(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.DeveloperInfo
  ): zio.aws.alexaforbusiness.model.DeveloperInfo.ReadOnly = new Wrapper(impl)
}
