package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.Arn
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteRoomRequest(roomArn: Option[Arn] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.DeleteRoomRequest = {
    import DeleteRoomRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.DeleteRoomRequest
      .builder()
      .optionallyWith(
        roomArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.roomArn)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.DeleteRoomRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.DeleteRoomRequest.wrap(buildAwsValue())
}
object DeleteRoomRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.DeleteRoomRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.DeleteRoomRequest =
      zio.aws.alexaforbusiness.model
        .DeleteRoomRequest(roomArn.map(value => value))
    def roomArn: Option[Arn]
    def getRoomArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("roomArn", roomArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.DeleteRoomRequest
  ) extends zio.aws.alexaforbusiness.model.DeleteRoomRequest.ReadOnly {
    override val roomArn: Option[Arn] = scala
      .Option(impl.roomArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.DeleteRoomRequest
  ): zio.aws.alexaforbusiness.model.DeleteRoomRequest.ReadOnly = new Wrapper(
    impl
  )
}
