package zio.aws.alexaforbusiness.model
import java.lang.Integer
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.Minutes
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateEndOfMeetingReminder(
    reminderAtMinutes: Iterable[Minutes],
    reminderType: zio.aws.alexaforbusiness.model.EndOfMeetingReminderType,
    enabled: Boolean
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.CreateEndOfMeetingReminder = {
    import CreateEndOfMeetingReminder.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.CreateEndOfMeetingReminder
      .builder()
      .reminderAtMinutes(reminderAtMinutes.map { item =>
        Minutes.unwrap(item): Integer
      }.asJavaCollection)
      .reminderType(reminderType.unwrap)
      .enabled(enabled: java.lang.Boolean)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.CreateEndOfMeetingReminder.ReadOnly =
    zio.aws.alexaforbusiness.model.CreateEndOfMeetingReminder
      .wrap(buildAwsValue())
}
object CreateEndOfMeetingReminder {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.CreateEndOfMeetingReminder
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.CreateEndOfMeetingReminder =
      zio.aws.alexaforbusiness.model
        .CreateEndOfMeetingReminder(reminderAtMinutes, reminderType, enabled)
    def reminderAtMinutes: List[Minutes]
    def reminderType: zio.aws.alexaforbusiness.model.EndOfMeetingReminderType
    def enabled: Boolean
    def getReminderAtMinutes: ZIO[Any, Nothing, List[Minutes]] =
      ZIO.succeed(reminderAtMinutes)
    def getReminderType: ZIO[
      Any,
      Nothing,
      zio.aws.alexaforbusiness.model.EndOfMeetingReminderType
    ] = ZIO.succeed(reminderType)
    def getEnabled: ZIO[Any, Nothing, Boolean] = ZIO.succeed(enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.CreateEndOfMeetingReminder
  ) extends zio.aws.alexaforbusiness.model.CreateEndOfMeetingReminder.ReadOnly {
    override val reminderAtMinutes: List[Minutes] = impl
      .reminderAtMinutes()
      .asScala
      .map { item =>
        zio.aws.alexaforbusiness.model.primitives.Minutes(item)
      }
      .toList
    override val reminderType
        : zio.aws.alexaforbusiness.model.EndOfMeetingReminderType =
      zio.aws.alexaforbusiness.model.EndOfMeetingReminderType
        .wrap(impl.reminderType())
    override val enabled: Boolean = impl.enabled(): Boolean
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.CreateEndOfMeetingReminder
  ): zio.aws.alexaforbusiness.model.CreateEndOfMeetingReminder.ReadOnly =
    new Wrapper(impl)
}
