package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.Arn
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateAddressBookResponse(addressBookArn: Option[Arn] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.CreateAddressBookResponse = {
    import CreateAddressBookResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.CreateAddressBookResponse
      .builder()
      .optionallyWith(
        addressBookArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.addressBookArn)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.CreateAddressBookResponse.ReadOnly =
    zio.aws.alexaforbusiness.model.CreateAddressBookResponse
      .wrap(buildAwsValue())
}
object CreateAddressBookResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.CreateAddressBookResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.CreateAddressBookResponse =
      zio.aws.alexaforbusiness.model
        .CreateAddressBookResponse(addressBookArn.map(value => value))
    def addressBookArn: Option[Arn]
    def getAddressBookArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("addressBookArn", addressBookArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.CreateAddressBookResponse
  ) extends zio.aws.alexaforbusiness.model.CreateAddressBookResponse.ReadOnly {
    override val addressBookArn: Option[Arn] = scala
      .Option(impl.addressBookArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.CreateAddressBookResponse
  ): zio.aws.alexaforbusiness.model.CreateAddressBookResponse.ReadOnly =
    new Wrapper(impl)
}
