package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{
  ClientRequestToken,
  AddressBookDescription,
  AddressBookName
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateAddressBookRequest(
    name: AddressBookName,
    description: Option[AddressBookDescription] = None,
    clientRequestToken: Option[ClientRequestToken] = None,
    tags: Option[Iterable[zio.aws.alexaforbusiness.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.CreateAddressBookRequest = {
    import CreateAddressBookRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.CreateAddressBookRequest
      .builder()
      .name(AddressBookName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value =>
          AddressBookDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.CreateAddressBookRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.CreateAddressBookRequest
      .wrap(buildAwsValue())
}
object CreateAddressBookRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.CreateAddressBookRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.CreateAddressBookRequest =
      zio.aws.alexaforbusiness.model.CreateAddressBookRequest(
        name,
        description.map(value => value),
        clientRequestToken.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: AddressBookName
    def description: Option[AddressBookDescription]
    def clientRequestToken: Option[ClientRequestToken]
    def tags: Option[List[zio.aws.alexaforbusiness.model.Tag.ReadOnly]]
    def getName: ZIO[Any, Nothing, AddressBookName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, AddressBookDescription] =
      AwsError.unwrapOptionField("description", description)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.alexaforbusiness.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.CreateAddressBookRequest
  ) extends zio.aws.alexaforbusiness.model.CreateAddressBookRequest.ReadOnly {
    override val name: AddressBookName =
      zio.aws.alexaforbusiness.model.primitives.AddressBookName(impl.name())
    override val description: Option[AddressBookDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.AddressBookDescription(value)
      )
    override val clientRequestToken: Option[ClientRequestToken] = scala
      .Option(impl.clientRequestToken())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.ClientRequestToken(value)
      )
    override val tags
        : Option[List[zio.aws.alexaforbusiness.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.alexaforbusiness.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.CreateAddressBookRequest
  ): zio.aws.alexaforbusiness.model.CreateAddressBookRequest.ReadOnly =
    new Wrapper(impl)
}
