package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{
  RawPhoneNumber,
  ContactName,
  Arn
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ContactData(
    contactArn: Option[Arn] = None,
    displayName: Option[ContactName] = None,
    firstName: Option[ContactName] = None,
    lastName: Option[ContactName] = None,
    phoneNumber: Option[RawPhoneNumber] = None,
    phoneNumbers: Option[Iterable[zio.aws.alexaforbusiness.model.PhoneNumber]] =
      None,
    sipAddresses: Option[Iterable[zio.aws.alexaforbusiness.model.SipAddress]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.ContactData = {
    import ContactData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.ContactData
      .builder()
      .optionallyWith(
        contactArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.contactArn)
      .optionallyWith(
        displayName.map(value => ContactName.unwrap(value): java.lang.String)
      )(_.displayName)
      .optionallyWith(
        firstName.map(value => ContactName.unwrap(value): java.lang.String)
      )(_.firstName)
      .optionallyWith(
        lastName.map(value => ContactName.unwrap(value): java.lang.String)
      )(_.lastName)
      .optionallyWith(
        phoneNumber.map(value => RawPhoneNumber.unwrap(value): java.lang.String)
      )(_.phoneNumber)
      .optionallyWith(
        phoneNumbers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.phoneNumbers)
      .optionallyWith(
        sipAddresses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sipAddresses)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.ContactData.ReadOnly =
    zio.aws.alexaforbusiness.model.ContactData.wrap(buildAwsValue())
}
object ContactData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.ContactData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.ContactData =
      zio.aws.alexaforbusiness.model.ContactData(
        contactArn.map(value => value),
        displayName.map(value => value),
        firstName.map(value => value),
        lastName.map(value => value),
        phoneNumber.map(value => value),
        phoneNumbers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sipAddresses.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def contactArn: Option[Arn]
    def displayName: Option[ContactName]
    def firstName: Option[ContactName]
    def lastName: Option[ContactName]
    def phoneNumber: Option[RawPhoneNumber]
    def phoneNumbers
        : Option[List[zio.aws.alexaforbusiness.model.PhoneNumber.ReadOnly]]
    def sipAddresses
        : Option[List[zio.aws.alexaforbusiness.model.SipAddress.ReadOnly]]
    def getContactArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("contactArn", contactArn)
    def getDisplayName: ZIO[Any, AwsError, ContactName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getFirstName: ZIO[Any, AwsError, ContactName] =
      AwsError.unwrapOptionField("firstName", firstName)
    def getLastName: ZIO[Any, AwsError, ContactName] =
      AwsError.unwrapOptionField("lastName", lastName)
    def getPhoneNumber: ZIO[Any, AwsError, RawPhoneNumber] =
      AwsError.unwrapOptionField("phoneNumber", phoneNumber)
    def getPhoneNumbers: ZIO[Any, AwsError, List[
      zio.aws.alexaforbusiness.model.PhoneNumber.ReadOnly
    ]] = AwsError.unwrapOptionField("phoneNumbers", phoneNumbers)
    def getSipAddresses: ZIO[Any, AwsError, List[
      zio.aws.alexaforbusiness.model.SipAddress.ReadOnly
    ]] = AwsError.unwrapOptionField("sipAddresses", sipAddresses)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.ContactData
  ) extends zio.aws.alexaforbusiness.model.ContactData.ReadOnly {
    override val contactArn: Option[Arn] = scala
      .Option(impl.contactArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
    override val displayName: Option[ContactName] = scala
      .Option(impl.displayName())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.ContactName(value)
      )
    override val firstName: Option[ContactName] = scala
      .Option(impl.firstName())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.ContactName(value)
      )
    override val lastName: Option[ContactName] = scala
      .Option(impl.lastName())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.ContactName(value)
      )
    override val phoneNumber: Option[RawPhoneNumber] = scala
      .Option(impl.phoneNumber())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.RawPhoneNumber(value)
      )
    override val phoneNumbers
        : Option[List[zio.aws.alexaforbusiness.model.PhoneNumber.ReadOnly]] =
      scala
        .Option(impl.phoneNumbers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.alexaforbusiness.model.PhoneNumber.wrap(item)
          }.toList
        )
    override val sipAddresses
        : Option[List[zio.aws.alexaforbusiness.model.SipAddress.ReadOnly]] =
      scala
        .Option(impl.sipAddresses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.alexaforbusiness.model.SipAddress.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.ContactData
  ): zio.aws.alexaforbusiness.model.ContactData.ReadOnly = new Wrapper(impl)
}
