package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{CategoryName, CategoryId}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Category(
    categoryId: Option[CategoryId] = None,
    categoryName: Option[CategoryName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.Category = {
    import Category.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.Category
      .builder()
      .optionallyWith(
        categoryId.map(value => CategoryId.unwrap(value): java.lang.Long)
      )(_.categoryId)
      .optionallyWith(
        categoryName.map(value => CategoryName.unwrap(value): java.lang.String)
      )(_.categoryName)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.Category.ReadOnly =
    zio.aws.alexaforbusiness.model.Category.wrap(buildAwsValue())
}
object Category {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.Category
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.Category =
      zio.aws.alexaforbusiness.model.Category(
        categoryId.map(value => value),
        categoryName.map(value => value)
      )
    def categoryId: Option[CategoryId]
    def categoryName: Option[CategoryName]
    def getCategoryId: ZIO[Any, AwsError, CategoryId] =
      AwsError.unwrapOptionField("categoryId", categoryId)
    def getCategoryName: ZIO[Any, AwsError, CategoryName] =
      AwsError.unwrapOptionField("categoryName", categoryName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.Category
  ) extends zio.aws.alexaforbusiness.model.Category.ReadOnly {
    override val categoryId: Option[CategoryId] = scala
      .Option(impl.categoryId())
      .map(value => zio.aws.alexaforbusiness.model.primitives.CategoryId(value))
    override val categoryName: Option[CategoryName] = scala
      .Option(impl.categoryName())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.CategoryName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.Category
  ): zio.aws.alexaforbusiness.model.Category.ReadOnly = new Wrapper(impl)
}
