package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{
  BusinessReportDownloadUrl,
  BusinessReportDeliveryTime
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class BusinessReport(
    status: Option[zio.aws.alexaforbusiness.model.BusinessReportStatus] = None,
    failureCode: Option[
      zio.aws.alexaforbusiness.model.BusinessReportFailureCode
    ] = None,
    s3Location: Option[
      zio.aws.alexaforbusiness.model.BusinessReportS3Location
    ] = None,
    deliveryTime: Option[BusinessReportDeliveryTime] = None,
    downloadUrl: Option[BusinessReportDownloadUrl] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.BusinessReport = {
    import BusinessReport.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.BusinessReport
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(failureCode.map(value => value.unwrap))(_.failureCode)
      .optionallyWith(s3Location.map(value => value.buildAwsValue()))(
        _.s3Location
      )
      .optionallyWith(
        deliveryTime.map(value =>
          BusinessReportDeliveryTime.unwrap(value): Instant
        )
      )(_.deliveryTime)
      .optionallyWith(
        downloadUrl.map(value =>
          BusinessReportDownloadUrl.unwrap(value): java.lang.String
        )
      )(_.downloadUrl)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.BusinessReport.ReadOnly =
    zio.aws.alexaforbusiness.model.BusinessReport.wrap(buildAwsValue())
}
object BusinessReport {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.BusinessReport
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.BusinessReport =
      zio.aws.alexaforbusiness.model.BusinessReport(
        status.map(value => value),
        failureCode.map(value => value),
        s3Location.map(value => value.asEditable),
        deliveryTime.map(value => value),
        downloadUrl.map(value => value)
      )
    def status: Option[zio.aws.alexaforbusiness.model.BusinessReportStatus]
    def failureCode
        : Option[zio.aws.alexaforbusiness.model.BusinessReportFailureCode]
    def s3Location: Option[
      zio.aws.alexaforbusiness.model.BusinessReportS3Location.ReadOnly
    ]
    def deliveryTime: Option[BusinessReportDeliveryTime]
    def downloadUrl: Option[BusinessReportDownloadUrl]
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.alexaforbusiness.model.BusinessReportStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getFailureCode: ZIO[
      Any,
      AwsError,
      zio.aws.alexaforbusiness.model.BusinessReportFailureCode
    ] = AwsError.unwrapOptionField("failureCode", failureCode)
    def getS3Location: ZIO[
      Any,
      AwsError,
      zio.aws.alexaforbusiness.model.BusinessReportS3Location.ReadOnly
    ] = AwsError.unwrapOptionField("s3Location", s3Location)
    def getDeliveryTime: ZIO[Any, AwsError, BusinessReportDeliveryTime] =
      AwsError.unwrapOptionField("deliveryTime", deliveryTime)
    def getDownloadUrl: ZIO[Any, AwsError, BusinessReportDownloadUrl] =
      AwsError.unwrapOptionField("downloadUrl", downloadUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.BusinessReport
  ) extends zio.aws.alexaforbusiness.model.BusinessReport.ReadOnly {
    override val status
        : Option[zio.aws.alexaforbusiness.model.BusinessReportStatus] = scala
      .Option(impl.status())
      .map(value =>
        zio.aws.alexaforbusiness.model.BusinessReportStatus.wrap(value)
      )
    override val failureCode
        : Option[zio.aws.alexaforbusiness.model.BusinessReportFailureCode] =
      scala
        .Option(impl.failureCode())
        .map(value =>
          zio.aws.alexaforbusiness.model.BusinessReportFailureCode.wrap(value)
        )
    override val s3Location: Option[
      zio.aws.alexaforbusiness.model.BusinessReportS3Location.ReadOnly
    ] = scala
      .Option(impl.s3Location())
      .map(value =>
        zio.aws.alexaforbusiness.model.BusinessReportS3Location.wrap(value)
      )
    override val deliveryTime: Option[BusinessReportDeliveryTime] = scala
      .Option(impl.deliveryTime())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives
          .BusinessReportDeliveryTime(value)
      )
    override val downloadUrl: Option[BusinessReportDownloadUrl] = scala
      .Option(impl.downloadUrl())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives
          .BusinessReportDownloadUrl(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.BusinessReport
  ): zio.aws.alexaforbusiness.model.BusinessReport.ReadOnly = new Wrapper(impl)
}
