package zio.aws.alexaforbusiness
import zio.aws.alexaforbusiness.model.DisassociateDeviceFromRoomResponse.ReadOnly
import zio.aws.alexaforbusiness.model.{
  DeleteUserRequest,
  StartSmartHomeApplianceDiscoveryRequest,
  UpdateProfileRequest,
  GetProfileRequest,
  UpdateBusinessReportScheduleRequest,
  SearchDevicesRequest,
  DisassociateSkillFromUsersRequest,
  CreateContactRequest,
  DeleteSkillGroupRequest,
  ListBusinessReportSchedulesRequest,
  ListTagsRequest,
  DeleteContactRequest,
  ListSkillsStoreSkillsByCategoryRequest,
  AssociateSkillWithSkillGroupRequest,
  DeleteRoomSkillParameterRequest,
  ForgetSmartHomeAppliancesRequest,
  ApproveSkillRequest,
  GetContactRequest,
  SearchProfilesRequest,
  SearchNetworkProfilesRequest,
  GetDeviceRequest,
  DeleteNetworkProfileRequest,
  DisassociateDeviceFromRoomRequest,
  GetInvitationConfigurationRequest,
  UpdateGatewayRequest,
  DisassociateSkillGroupFromRoomRequest,
  GetConferencePreferenceRequest,
  CreateProfileRequest,
  ListDeviceEventsRequest,
  AssociateSkillWithUsersRequest,
  SearchSkillGroupsRequest,
  RevokeInvitationRequest,
  UpdateNetworkProfileRequest,
  DeleteRoomRequest,
  DisassociateContactFromAddressBookRequest,
  GetNetworkProfileRequest,
  UpdateGatewayGroupRequest,
  UpdateConferenceProviderRequest,
  CreateRoomRequest,
  GetAddressBookRequest,
  SearchUsersRequest,
  DeleteProfileRequest,
  ListConferenceProvidersRequest,
  CreateUserRequest,
  UpdateAddressBookRequest,
  PutInvitationConfigurationRequest,
  SendInvitationRequest,
  DisassociateSkillFromSkillGroupRequest,
  CreateAddressBookRequest,
  GetRoomSkillParameterRequest,
  GetGatewayRequest,
  ListSkillsRequest,
  GetSkillGroupRequest,
  PutRoomSkillParameterRequest,
  SendAnnouncementRequest,
  AssociateSkillGroupWithRoomRequest,
  GetGatewayGroupRequest,
  SearchContactsRequest,
  DeleteGatewayGroupRequest,
  UntagResourceRequest,
  ListSkillsStoreCategoriesRequest,
  DeleteBusinessReportScheduleRequest,
  DeleteConferenceProviderRequest,
  SearchRoomsRequest,
  DeleteAddressBookRequest,
  DeleteDeviceUsageDataRequest,
  DeleteSkillAuthorizationRequest,
  RejectSkillRequest,
  ResolveRoomRequest,
  UpdateRoomRequest,
  UpdateDeviceRequest,
  UpdateSkillGroupRequest,
  ListSmartHomeAppliancesRequest,
  CreateGatewayGroupRequest,
  PutConferencePreferenceRequest,
  CreateNetworkProfileRequest,
  StartDeviceSyncRequest,
  ListGatewaysRequest,
  CreateConferenceProviderRequest,
  CreateSkillGroupRequest,
  DeleteDeviceRequest,
  AssociateContactWithAddressBookRequest,
  GetConferenceProviderRequest,
  UpdateContactRequest,
  CreateBusinessReportScheduleRequest,
  GetRoomRequest,
  ListGatewayGroupsRequest,
  TagResourceRequest,
  AssociateDeviceWithRoomRequest,
  SearchAddressBooksRequest,
  PutSkillAuthorizationRequest,
  AssociateDeviceWithNetworkProfileRequest,
  RegisterAvsDeviceRequest
}
import software.amazon.awssdk.services.alexaforbusiness.model.{
  CreateContactResponse,
  SearchAddressBooksResponse,
  AssociateSkillWithUsersResponse,
  UpdateBusinessReportScheduleResponse,
  SendAnnouncementResponse,
  DeleteDeviceResponse,
  DisassociateSkillFromSkillGroupResponse,
  StartDeviceSyncResponse,
  ResolveRoomResponse,
  AddressBookData,
  UpdateProfileResponse,
  UpdateGatewayResponse,
  CreateGatewayGroupResponse,
  SearchDevicesResponse,
  SmartHomeAppliance,
  DeviceEvent,
  UpdateSkillGroupResponse,
  ListSkillsStoreCategoriesResponse,
  GetInvitationConfigurationResponse,
  AssociateDeviceWithNetworkProfileResponse,
  SearchRoomsResponse,
  GetRoomSkillParameterResponse,
  SkillsStoreSkill,
  BusinessReportSchedule,
  AssociateSkillGroupWithRoomResponse,
  DisassociateSkillFromUsersResponse,
  DeleteAddressBookResponse,
  ListSkillsResponse,
  AssociateSkillWithSkillGroupResponse,
  GetContactResponse,
  GetGatewayResponse,
  SearchSkillGroupsResponse,
  ListBusinessReportSchedulesResponse,
  CreateConferenceProviderResponse,
  RegisterAvsDeviceResponse,
  ListDeviceEventsResponse,
  UpdateContactResponse,
  CreateBusinessReportScheduleResponse,
  DisassociateSkillGroupFromRoomResponse,
  ListGatewaysResponse,
  DeleteProfileResponse,
  Tag,
  DeleteConferenceProviderResponse,
  DeleteBusinessReportScheduleResponse,
  GetProfileResponse,
  UpdateConferenceProviderResponse,
  GetNetworkProfileResponse,
  DisassociateDeviceFromRoomResponse,
  DeleteGatewayGroupResponse,
  RoomData,
  SkillGroupData,
  StartSmartHomeApplianceDiscoveryResponse,
  DeviceData,
  SearchUsersResponse,
  UpdateNetworkProfileResponse,
  ProfileData,
  PutConferencePreferenceResponse,
  RejectSkillResponse,
  GetConferenceProviderResponse,
  PutInvitationConfigurationResponse,
  UpdateRoomResponse,
  SkillSummary,
  UntagResourceResponse,
  PutSkillAuthorizationResponse,
  GetRoomResponse,
  CreateAddressBookResponse,
  GetDeviceResponse,
  GetConferencePreferenceResponse,
  ListSmartHomeAppliancesResponse,
  CreateNetworkProfileResponse,
  SearchContactsResponse,
  GetGatewayGroupResponse,
  UpdateAddressBookResponse,
  CreateUserResponse,
  DeleteSkillGroupResponse,
  DisassociateContactFromAddressBookResponse,
  GetSkillGroupResponse,
  DeleteSkillAuthorizationResponse,
  ListSkillsStoreSkillsByCategoryResponse,
  NetworkProfileData,
  GetAddressBookResponse,
  ContactData,
  ListConferenceProvidersResponse,
  DeleteNetworkProfileResponse,
  UserData,
  DeleteUserResponse,
  RevokeInvitationResponse,
  SendInvitationResponse,
  SearchProfilesResponse,
  UpdateGatewayGroupResponse,
  GatewaySummary,
  UpdateDeviceResponse,
  CreateProfileResponse,
  DeleteDeviceUsageDataResponse,
  Category,
  GatewayGroupSummary,
  DeleteRoomSkillParameterResponse,
  AssociateDeviceWithRoomResponse,
  DeleteRoomResponse,
  TagResourceResponse,
  ListGatewayGroupsResponse,
  SearchNetworkProfilesResponse,
  ConferenceProvider,
  ApproveSkillResponse,
  DeleteContactResponse,
  ForgetSmartHomeAppliancesResponse,
  CreateSkillGroupResponse,
  ListTagsResponse,
  AssociateContactWithAddressBookResponse,
  CreateRoomResponse,
  PutRoomSkillParameterResponse
}
import zio.aws.core.config.AwsConfig
import zio.aws.core.{AwsServiceBase, StreamingOutputResult, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import software.amazon.awssdk.services.alexaforbusiness.{
  AlexaForBusinessAsyncClientBuilder,
  AlexaForBusinessAsyncClient
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait AlexaForBusiness extends AspectSupport[AlexaForBusiness] {
  val api: AlexaForBusinessAsyncClient
  def updateContact(
      request: UpdateContactRequest
  ): IO[AwsError, zio.aws.alexaforbusiness.model.UpdateContactResponse.ReadOnly]
  def deleteRoomSkillParameter(request: DeleteRoomSkillParameterRequest): IO[
    AwsError,
    zio.aws.alexaforbusiness.model.DeleteRoomSkillParameterResponse.ReadOnly
  ]
  def associateSkillWithUsers(request: AssociateSkillWithUsersRequest): IO[
    AwsError,
    zio.aws.alexaforbusiness.model.AssociateSkillWithUsersResponse.ReadOnly
  ]
  def deleteSkillAuthorization(request: DeleteSkillAuthorizationRequest): IO[
    AwsError,
    zio.aws.alexaforbusiness.model.DeleteSkillAuthorizationResponse.ReadOnly
  ]
  def deleteConferenceProvider(request: DeleteConferenceProviderRequest): IO[
    AwsError,
    zio.aws.alexaforbusiness.model.DeleteConferenceProviderResponse.ReadOnly
  ]
  def updateGateway(
      request: UpdateGatewayRequest
  ): IO[AwsError, zio.aws.alexaforbusiness.model.UpdateGatewayResponse.ReadOnly]
  def updateGatewayGroup(request: UpdateGatewayGroupRequest): IO[
    AwsError,
    zio.aws.alexaforbusiness.model.UpdateGatewayGroupResponse.ReadOnly
  ]
  def searchUsers(
      request: SearchUsersRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.alexaforbusiness.model.SearchUsersResponse.ReadOnly,
    zio.aws.alexaforbusiness.model.UserData.ReadOnly
  ]]
  def searchUsersPaginated(
      request: SearchUsersRequest
  ): IO[AwsError, zio.aws.alexaforbusiness.model.SearchUsersResponse.ReadOnly]
  def searchSkillGroups(
      request: SearchSkillGroupsRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.alexaforbusiness.model.SearchSkillGroupsResponse.ReadOnly,
    zio.aws.alexaforbusiness.model.SkillGroupData.ReadOnly
  ]]
  def searchSkillGroupsPaginated(request: SearchSkillGroupsRequest): IO[
    AwsError,
    zio.aws.alexaforbusiness.model.SearchSkillGroupsResponse.ReadOnly
  ]
  def associateSkillWithSkillGroup(
      request: AssociateSkillWithSkillGroupRequest
  ): IO[
    AwsError,
    zio.aws.alexaforbusiness.model.AssociateSkillWithSkillGroupResponse.ReadOnly
  ]
  def revokeInvitation(request: RevokeInvitationRequest): IO[
    AwsError,
    zio.aws.alexaforbusiness.model.RevokeInvitationResponse.ReadOnly
  ]
  def listSkillsStoreCategories(
      request: ListSkillsStoreCategoriesRequest
  ): ZStream[Any, AwsError, zio.aws.alexaforbusiness.model.Category.ReadOnly]
  def listSkillsStoreCategoriesPaginated(
      request: ListSkillsStoreCategoriesRequest
  ): IO[
    AwsError,
    zio.aws.alexaforbusiness.model.ListSkillsStoreCategoriesResponse.ReadOnly
  ]
  def disassociateSkillFromSkillGroup(
      request: DisassociateSkillFromSkillGroupRequest
  ): IO[
    AwsError,
    zio.aws.alexaforbusiness.model.DisassociateSkillFromSkillGroupResponse.ReadOnly
  ]
  def getRoomSkillParameter(request: GetRoomSkillParameterRequest): IO[
    AwsError,
    zio.aws.alexaforbusiness.model.GetRoomSkillParameterResponse.ReadOnly
  ]
  def updateNetworkProfile(request: UpdateNetworkProfileRequest): IO[
    AwsError,
    zio.aws.alexaforbusiness.model.UpdateNetworkProfileResponse.ReadOnly
  ]
  def associateContactWithAddressBook(
      request: AssociateContactWithAddressBookRequest
  ): IO[
    AwsError,
    zio.aws.alexaforbusiness.model.AssociateContactWithAddressBookResponse.ReadOnly
  ]
  def listConferenceProviders(request: ListConferenceProvidersRequest): ZStream[
    Any,
    AwsError,
    zio.aws.alexaforbusiness.model.ConferenceProvider.ReadOnly
  ]
  def listConferenceProvidersPaginated(
      request: ListConferenceProvidersRequest
  ): IO[
    AwsError,
    zio.aws.alexaforbusiness.model.ListConferenceProvidersResponse.ReadOnly
  ]
  def listSkillsStoreSkillsByCategory(
      request: ListSkillsStoreSkillsByCategoryRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.alexaforbusiness.model.SkillsStoreSkill.ReadOnly
  ]
  def listSkillsStoreSkillsByCategoryPaginated(
      request: ListSkillsStoreSkillsByCategoryRequest
  ): IO[
    AwsError,
    zio.aws.alexaforbusiness.model.ListSkillsStoreSkillsByCategoryResponse.ReadOnly
  ]
  def listTags(
      request: ListTagsRequest
  ): ZStream[Any, AwsError, zio.aws.alexaforbusiness.model.Tag.ReadOnly]
  def listTagsPaginated(
      request: ListTagsRequest
  ): IO[AwsError, zio.aws.alexaforbusiness.model.ListTagsResponse.ReadOnly]
  def deleteAddressBook(request: DeleteAddressBookRequest): IO[
    AwsError,
    zio.aws.alexaforbusiness.model.DeleteAddressBookResponse.ReadOnly
  ]
  def createConferenceProvider(request: CreateConferenceProviderRequest): IO[
    AwsError,
    zio.aws.alexaforbusiness.model.CreateConferenceProviderResponse.ReadOnly
  ]
  def deleteDevice(
      request: DeleteDeviceRequest
  ): IO[AwsError, zio.aws.alexaforbusiness.model.DeleteDeviceResponse.ReadOnly]
  def createGatewayGroup(request: CreateGatewayGroupRequest): IO[
    AwsError,
    zio.aws.alexaforbusiness.model.CreateGatewayGroupResponse.ReadOnly
  ]
  def getGatewayGroup(request: GetGatewayGroupRequest): IO[
    AwsError,
    zio.aws.alexaforbusiness.model.GetGatewayGroupResponse.ReadOnly
  ]
  def updateRoom(
      request: UpdateRoomRequest
  ): IO[AwsError, zio.aws.alexaforbusiness.model.UpdateRoomResponse.ReadOnly]
  def deleteContact(
      request: DeleteContactRequest
  ): IO[AwsError, zio.aws.alexaforbusiness.model.DeleteContactResponse.ReadOnly]
  def updateBusinessReportSchedule(
      request: UpdateBusinessReportScheduleRequest
  ): IO[
    AwsError,
    zio.aws.alexaforbusiness.model.UpdateBusinessReportScheduleResponse.ReadOnly
  ]
  def associateDeviceWithNetworkProfile(
      request: AssociateDeviceWithNetworkProfileRequest
  ): IO[
    AwsError,
    zio.aws.alexaforbusiness.model.AssociateDeviceWithNetworkProfileResponse.ReadOnly
  ]
  def createContact(
      request: CreateContactRequest
  ): IO[AwsError, zio.aws.alexaforbusiness.model.CreateContactResponse.ReadOnly]
  def putSkillAuthorization(request: PutSkillAuthorizationRequest): IO[
    AwsError,
    zio.aws.alexaforbusiness.model.PutSkillAuthorizationResponse.ReadOnly
  ]
  def createAddressBook(request: CreateAddressBookRequest): IO[
    AwsError,
    zio.aws.alexaforbusiness.model.CreateAddressBookResponse.ReadOnly
  ]
  def updateConferenceProvider(request: UpdateConferenceProviderRequest): IO[
    AwsError,
    zio.aws.alexaforbusiness.model.UpdateConferenceProviderResponse.ReadOnly
  ]
  def listDeviceEvents(
      request: ListDeviceEventsRequest
  ): ZStream[Any, AwsError, zio.aws.alexaforbusiness.model.DeviceEvent.ReadOnly]
  def listDeviceEventsPaginated(request: ListDeviceEventsRequest): IO[
    AwsError,
    zio.aws.alexaforbusiness.model.ListDeviceEventsResponse.ReadOnly
  ]
  def sendInvitation(request: SendInvitationRequest): IO[
    AwsError,
    zio.aws.alexaforbusiness.model.SendInvitationResponse.ReadOnly
  ]
  def getConferenceProvider(request: GetConferenceProviderRequest): IO[
    AwsError,
    zio.aws.alexaforbusiness.model.GetConferenceProviderResponse.ReadOnly
  ]
  def getNetworkProfile(request: GetNetworkProfileRequest): IO[
    AwsError,
    zio.aws.alexaforbusiness.model.GetNetworkProfileResponse.ReadOnly
  ]
  def disassociateDeviceFromRoom(
      request: DisassociateDeviceFromRoomRequest
  ): IO[AwsError, ReadOnly]
  def getSkillGroup(
      request: GetSkillGroupRequest
  ): IO[AwsError, zio.aws.alexaforbusiness.model.GetSkillGroupResponse.ReadOnly]
  def approveSkill(
      request: ApproveSkillRequest
  ): IO[AwsError, zio.aws.alexaforbusiness.model.ApproveSkillResponse.ReadOnly]
  def listSkills(request: ListSkillsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.alexaforbusiness.model.SkillSummary.ReadOnly
  ]
  def listSkillsPaginated(
      request: ListSkillsRequest
  ): IO[AwsError, zio.aws.alexaforbusiness.model.ListSkillsResponse.ReadOnly]
  def createUser(
      request: CreateUserRequest
  ): IO[AwsError, zio.aws.alexaforbusiness.model.CreateUserResponse.ReadOnly]
  def updateSkillGroup(request: UpdateSkillGroupRequest): IO[
    AwsError,
    zio.aws.alexaforbusiness.model.UpdateSkillGroupResponse.ReadOnly
  ]
  def deleteSkillGroup(request: DeleteSkillGroupRequest): IO[
    AwsError,
    zio.aws.alexaforbusiness.model.DeleteSkillGroupResponse.ReadOnly
  ]
  def rejectSkill(
      request: RejectSkillRequest
  ): IO[AwsError, zio.aws.alexaforbusiness.model.RejectSkillResponse.ReadOnly]
  def deleteBusinessReportSchedule(
      request: DeleteBusinessReportScheduleRequest
  ): IO[
    AwsError,
    zio.aws.alexaforbusiness.model.DeleteBusinessReportScheduleResponse.ReadOnly
  ]
  def getAddressBook(request: GetAddressBookRequest): IO[
    AwsError,
    zio.aws.alexaforbusiness.model.GetAddressBookResponse.ReadOnly
  ]
  def putInvitationConfiguration(
      request: PutInvitationConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.alexaforbusiness.model.PutInvitationConfigurationResponse.ReadOnly
  ]
  def listBusinessReportSchedules(
      request: ListBusinessReportSchedulesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.alexaforbusiness.model.BusinessReportSchedule.ReadOnly
  ]
  def listBusinessReportSchedulesPaginated(
      request: ListBusinessReportSchedulesRequest
  ): IO[
    AwsError,
    zio.aws.alexaforbusiness.model.ListBusinessReportSchedulesResponse.ReadOnly
  ]
  def listGatewayGroups(request: ListGatewayGroupsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.alexaforbusiness.model.GatewayGroupSummary.ReadOnly
  ]
  def listGatewayGroupsPaginated(request: ListGatewayGroupsRequest): IO[
    AwsError,
    zio.aws.alexaforbusiness.model.ListGatewayGroupsResponse.ReadOnly
  ]
  def deleteProfile(
      request: DeleteProfileRequest
  ): IO[AwsError, zio.aws.alexaforbusiness.model.DeleteProfileResponse.ReadOnly]
  def startSmartHomeApplianceDiscovery(
      request: StartSmartHomeApplianceDiscoveryRequest
  ): IO[
    AwsError,
    zio.aws.alexaforbusiness.model.StartSmartHomeApplianceDiscoveryResponse.ReadOnly
  ]
  def sendAnnouncement(request: SendAnnouncementRequest): IO[
    AwsError,
    zio.aws.alexaforbusiness.model.SendAnnouncementResponse.ReadOnly
  ]
  def getInvitationConfiguration(
      request: GetInvitationConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.alexaforbusiness.model.GetInvitationConfigurationResponse.ReadOnly
  ]
  def untagResource(
      request: UntagResourceRequest
  ): IO[AwsError, zio.aws.alexaforbusiness.model.UntagResourceResponse.ReadOnly]
  def associateSkillGroupWithRoom(
      request: AssociateSkillGroupWithRoomRequest
  ): IO[
    AwsError,
    zio.aws.alexaforbusiness.model.AssociateSkillGroupWithRoomResponse.ReadOnly
  ]
  def disassociateSkillGroupFromRoom(
      request: DisassociateSkillGroupFromRoomRequest
  ): IO[
    AwsError,
    zio.aws.alexaforbusiness.model.DisassociateSkillGroupFromRoomResponse.ReadOnly
  ]
  def startDeviceSync(request: StartDeviceSyncRequest): IO[
    AwsError,
    zio.aws.alexaforbusiness.model.StartDeviceSyncResponse.ReadOnly
  ]
  def associateDeviceWithRoom(request: AssociateDeviceWithRoomRequest): IO[
    AwsError,
    zio.aws.alexaforbusiness.model.AssociateDeviceWithRoomResponse.ReadOnly
  ]
  def createRoom(
      request: CreateRoomRequest
  ): IO[AwsError, zio.aws.alexaforbusiness.model.CreateRoomResponse.ReadOnly]
  def deleteRoom(
      request: DeleteRoomRequest
  ): IO[AwsError, zio.aws.alexaforbusiness.model.DeleteRoomResponse.ReadOnly]
  def getProfile(
      request: GetProfileRequest
  ): IO[AwsError, zio.aws.alexaforbusiness.model.GetProfileResponse.ReadOnly]
  def forgetSmartHomeAppliances(request: ForgetSmartHomeAppliancesRequest): IO[
    AwsError,
    zio.aws.alexaforbusiness.model.ForgetSmartHomeAppliancesResponse.ReadOnly
  ]
  def getConferencePreference(request: GetConferencePreferenceRequest): IO[
    AwsError,
    zio.aws.alexaforbusiness.model.GetConferencePreferenceResponse.ReadOnly
  ]
  def updateAddressBook(request: UpdateAddressBookRequest): IO[
    AwsError,
    zio.aws.alexaforbusiness.model.UpdateAddressBookResponse.ReadOnly
  ]
  def disassociateSkillFromUsers(
      request: DisassociateSkillFromUsersRequest
  ): IO[
    AwsError,
    zio.aws.alexaforbusiness.model.DisassociateSkillFromUsersResponse.ReadOnly
  ]
  def updateDevice(
      request: UpdateDeviceRequest
  ): IO[AwsError, zio.aws.alexaforbusiness.model.UpdateDeviceResponse.ReadOnly]
  def searchRooms(
      request: SearchRoomsRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.alexaforbusiness.model.SearchRoomsResponse.ReadOnly,
    zio.aws.alexaforbusiness.model.RoomData.ReadOnly
  ]]
  def searchRoomsPaginated(
      request: SearchRoomsRequest
  ): IO[AwsError, zio.aws.alexaforbusiness.model.SearchRoomsResponse.ReadOnly]
  def tagResource(
      request: TagResourceRequest
  ): IO[AwsError, zio.aws.alexaforbusiness.model.TagResourceResponse.ReadOnly]
  def disassociateContactFromAddressBook(
      request: DisassociateContactFromAddressBookRequest
  ): IO[
    AwsError,
    zio.aws.alexaforbusiness.model.DisassociateContactFromAddressBookResponse.ReadOnly
  ]
  def createProfile(
      request: CreateProfileRequest
  ): IO[AwsError, zio.aws.alexaforbusiness.model.CreateProfileResponse.ReadOnly]
  def deleteNetworkProfile(request: DeleteNetworkProfileRequest): IO[
    AwsError,
    zio.aws.alexaforbusiness.model.DeleteNetworkProfileResponse.ReadOnly
  ]
  def listSmartHomeAppliances(request: ListSmartHomeAppliancesRequest): ZStream[
    Any,
    AwsError,
    zio.aws.alexaforbusiness.model.SmartHomeAppliance.ReadOnly
  ]
  def listSmartHomeAppliancesPaginated(
      request: ListSmartHomeAppliancesRequest
  ): IO[
    AwsError,
    zio.aws.alexaforbusiness.model.ListSmartHomeAppliancesResponse.ReadOnly
  ]
  def getRoom(
      request: GetRoomRequest
  ): IO[AwsError, zio.aws.alexaforbusiness.model.GetRoomResponse.ReadOnly]
  def deleteUser(
      request: DeleteUserRequest
  ): IO[AwsError, zio.aws.alexaforbusiness.model.DeleteUserResponse.ReadOnly]
  def putConferencePreference(request: PutConferencePreferenceRequest): IO[
    AwsError,
    zio.aws.alexaforbusiness.model.PutConferencePreferenceResponse.ReadOnly
  ]
  def deleteGatewayGroup(request: DeleteGatewayGroupRequest): IO[
    AwsError,
    zio.aws.alexaforbusiness.model.DeleteGatewayGroupResponse.ReadOnly
  ]
  def searchDevices(
      request: SearchDevicesRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.alexaforbusiness.model.SearchDevicesResponse.ReadOnly,
    zio.aws.alexaforbusiness.model.DeviceData.ReadOnly
  ]]
  def searchDevicesPaginated(
      request: SearchDevicesRequest
  ): IO[AwsError, zio.aws.alexaforbusiness.model.SearchDevicesResponse.ReadOnly]
  def getContact(
      request: GetContactRequest
  ): IO[AwsError, zio.aws.alexaforbusiness.model.GetContactResponse.ReadOnly]
  def resolveRoom(
      request: ResolveRoomRequest
  ): IO[AwsError, zio.aws.alexaforbusiness.model.ResolveRoomResponse.ReadOnly]
  def registerAVSDevice(request: RegisterAvsDeviceRequest): IO[
    AwsError,
    zio.aws.alexaforbusiness.model.RegisterAvsDeviceResponse.ReadOnly
  ]
  def updateProfile(
      request: UpdateProfileRequest
  ): IO[AwsError, zio.aws.alexaforbusiness.model.UpdateProfileResponse.ReadOnly]
  def createSkillGroup(request: CreateSkillGroupRequest): IO[
    AwsError,
    zio.aws.alexaforbusiness.model.CreateSkillGroupResponse.ReadOnly
  ]
  def searchProfiles(
      request: SearchProfilesRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.alexaforbusiness.model.SearchProfilesResponse.ReadOnly,
    zio.aws.alexaforbusiness.model.ProfileData.ReadOnly
  ]]
  def searchProfilesPaginated(request: SearchProfilesRequest): IO[
    AwsError,
    zio.aws.alexaforbusiness.model.SearchProfilesResponse.ReadOnly
  ]
  def deleteDeviceUsageData(request: DeleteDeviceUsageDataRequest): IO[
    AwsError,
    zio.aws.alexaforbusiness.model.DeleteDeviceUsageDataResponse.ReadOnly
  ]
  def searchContacts(
      request: SearchContactsRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.alexaforbusiness.model.SearchContactsResponse.ReadOnly,
    zio.aws.alexaforbusiness.model.ContactData.ReadOnly
  ]]
  def searchContactsPaginated(request: SearchContactsRequest): IO[
    AwsError,
    zio.aws.alexaforbusiness.model.SearchContactsResponse.ReadOnly
  ]
  def getDevice(
      request: GetDeviceRequest
  ): IO[AwsError, zio.aws.alexaforbusiness.model.GetDeviceResponse.ReadOnly]
  def createNetworkProfile(request: CreateNetworkProfileRequest): IO[
    AwsError,
    zio.aws.alexaforbusiness.model.CreateNetworkProfileResponse.ReadOnly
  ]
  def createBusinessReportSchedule(
      request: CreateBusinessReportScheduleRequest
  ): IO[
    AwsError,
    zio.aws.alexaforbusiness.model.CreateBusinessReportScheduleResponse.ReadOnly
  ]
  def getGateway(
      request: GetGatewayRequest
  ): IO[AwsError, zio.aws.alexaforbusiness.model.GetGatewayResponse.ReadOnly]
  def searchNetworkProfiles(
      request: SearchNetworkProfilesRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.alexaforbusiness.model.SearchNetworkProfilesResponse.ReadOnly,
    zio.aws.alexaforbusiness.model.NetworkProfileData.ReadOnly
  ]]
  def searchNetworkProfilesPaginated(request: SearchNetworkProfilesRequest): IO[
    AwsError,
    zio.aws.alexaforbusiness.model.SearchNetworkProfilesResponse.ReadOnly
  ]
  def searchAddressBooks(
      request: SearchAddressBooksRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.alexaforbusiness.model.SearchAddressBooksResponse.ReadOnly,
    zio.aws.alexaforbusiness.model.AddressBookData.ReadOnly
  ]]
  def searchAddressBooksPaginated(request: SearchAddressBooksRequest): IO[
    AwsError,
    zio.aws.alexaforbusiness.model.SearchAddressBooksResponse.ReadOnly
  ]
  def putRoomSkillParameter(request: PutRoomSkillParameterRequest): IO[
    AwsError,
    zio.aws.alexaforbusiness.model.PutRoomSkillParameterResponse.ReadOnly
  ]
  def listGateways(request: ListGatewaysRequest): ZStream[
    Any,
    AwsError,
    zio.aws.alexaforbusiness.model.GatewaySummary.ReadOnly
  ]
  def listGatewaysPaginated(
      request: ListGatewaysRequest
  ): IO[AwsError, zio.aws.alexaforbusiness.model.ListGatewaysResponse.ReadOnly]
}
object AlexaForBusiness {
  val live: ZLayer[AwsConfig, java.lang.Throwable, AlexaForBusiness] =
    customized(identity)
  def customized(
      customization: AlexaForBusinessAsyncClientBuilder => AlexaForBusinessAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, AlexaForBusiness] = managed(
    customization
  ).toLayer
  def managed(
      customization: AlexaForBusinessAsyncClientBuilder => AlexaForBusinessAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, AlexaForBusiness] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = AlexaForBusinessAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[
        AlexaForBusinessAsyncClient,
        AlexaForBusinessAsyncClientBuilder
      ](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[
        AlexaForBusinessAsyncClient,
        AlexaForBusinessAsyncClientBuilder
      ](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  )
    yield new AlexaForBusinessImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class AlexaForBusinessImpl[R](
      override val api: AlexaForBusinessAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends AlexaForBusiness
      with AwsServiceBase[R] {
    override val serviceName: String = "AlexaForBusiness"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): AlexaForBusinessImpl[R1] = new AlexaForBusinessImpl(api, newAspect, r)
    def updateContact(request: UpdateContactRequest): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.UpdateContactResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.UpdateContactRequest,
      UpdateContactResponse
    ]("updateContact", api.updateContact)(request.buildAwsValue())
      .map(zio.aws.alexaforbusiness.model.UpdateContactResponse.wrap)
      .provideEnvironment(r)
    def deleteRoomSkillParameter(request: DeleteRoomSkillParameterRequest): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.DeleteRoomSkillParameterResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.DeleteRoomSkillParameterRequest,
      DeleteRoomSkillParameterResponse
    ]("deleteRoomSkillParameter", api.deleteRoomSkillParameter)(
      request.buildAwsValue()
    ).map(zio.aws.alexaforbusiness.model.DeleteRoomSkillParameterResponse.wrap)
      .provideEnvironment(r)
    def associateSkillWithUsers(request: AssociateSkillWithUsersRequest): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.AssociateSkillWithUsersResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.AssociateSkillWithUsersRequest,
      AssociateSkillWithUsersResponse
    ]("associateSkillWithUsers", api.associateSkillWithUsers)(
      request.buildAwsValue()
    ).map(zio.aws.alexaforbusiness.model.AssociateSkillWithUsersResponse.wrap)
      .provideEnvironment(r)
    def deleteSkillAuthorization(request: DeleteSkillAuthorizationRequest): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.DeleteSkillAuthorizationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.DeleteSkillAuthorizationRequest,
      DeleteSkillAuthorizationResponse
    ]("deleteSkillAuthorization", api.deleteSkillAuthorization)(
      request.buildAwsValue()
    ).map(zio.aws.alexaforbusiness.model.DeleteSkillAuthorizationResponse.wrap)
      .provideEnvironment(r)
    def deleteConferenceProvider(request: DeleteConferenceProviderRequest): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.DeleteConferenceProviderResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.DeleteConferenceProviderRequest,
      DeleteConferenceProviderResponse
    ]("deleteConferenceProvider", api.deleteConferenceProvider)(
      request.buildAwsValue()
    ).map(zio.aws.alexaforbusiness.model.DeleteConferenceProviderResponse.wrap)
      .provideEnvironment(r)
    def updateGateway(request: UpdateGatewayRequest): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.UpdateGatewayResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.UpdateGatewayRequest,
      UpdateGatewayResponse
    ]("updateGateway", api.updateGateway)(request.buildAwsValue())
      .map(zio.aws.alexaforbusiness.model.UpdateGatewayResponse.wrap)
      .provideEnvironment(r)
    def updateGatewayGroup(request: UpdateGatewayGroupRequest): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.UpdateGatewayGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.UpdateGatewayGroupRequest,
      UpdateGatewayGroupResponse
    ]("updateGatewayGroup", api.updateGatewayGroup)(request.buildAwsValue())
      .map(zio.aws.alexaforbusiness.model.UpdateGatewayGroupResponse.wrap)
      .provideEnvironment(r)
    def searchUsers(
        request: SearchUsersRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.alexaforbusiness.model.SearchUsersResponse.ReadOnly,
      zio.aws.alexaforbusiness.model.UserData.ReadOnly
    ]] = asyncPaginatedRequest[
      software.amazon.awssdk.services.alexaforbusiness.model.SearchUsersRequest,
      SearchUsersResponse,
      UserData
    ](
      "searchUsers",
      api.searchUsers,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.users().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(zio.aws.alexaforbusiness.model.SearchUsersResponse.wrap)
          .mapOutput(
            _.map(item => zio.aws.alexaforbusiness.model.UserData.wrap(item))
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def searchUsersPaginated(request: SearchUsersRequest): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.SearchUsersResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.SearchUsersRequest,
      SearchUsersResponse
    ]("searchUsers", api.searchUsers)(request.buildAwsValue())
      .map(zio.aws.alexaforbusiness.model.SearchUsersResponse.wrap)
      .provideEnvironment(r)
    def searchSkillGroups(
        request: SearchSkillGroupsRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.alexaforbusiness.model.SearchSkillGroupsResponse.ReadOnly,
      zio.aws.alexaforbusiness.model.SkillGroupData.ReadOnly
    ]] = asyncPaginatedRequest[
      software.amazon.awssdk.services.alexaforbusiness.model.SearchSkillGroupsRequest,
      SearchSkillGroupsResponse,
      SkillGroupData
    ](
      "searchSkillGroups",
      api.searchSkillGroups,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.skillGroups().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(
            zio.aws.alexaforbusiness.model.SearchSkillGroupsResponse.wrap
          )
          .mapOutput(
            _.map(item =>
              zio.aws.alexaforbusiness.model.SkillGroupData.wrap(item)
            )
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def searchSkillGroupsPaginated(request: SearchSkillGroupsRequest): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.SearchSkillGroupsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.SearchSkillGroupsRequest,
      SearchSkillGroupsResponse
    ]("searchSkillGroups", api.searchSkillGroups)(request.buildAwsValue())
      .map(zio.aws.alexaforbusiness.model.SearchSkillGroupsResponse.wrap)
      .provideEnvironment(r)
    def associateSkillWithSkillGroup(
        request: AssociateSkillWithSkillGroupRequest
    ): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.AssociateSkillWithSkillGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.AssociateSkillWithSkillGroupRequest,
      AssociateSkillWithSkillGroupResponse
    ]("associateSkillWithSkillGroup", api.associateSkillWithSkillGroup)(
      request.buildAwsValue()
    ).map(
      zio.aws.alexaforbusiness.model.AssociateSkillWithSkillGroupResponse.wrap
    ).provideEnvironment(r)
    def revokeInvitation(request: RevokeInvitationRequest): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.RevokeInvitationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.RevokeInvitationRequest,
      RevokeInvitationResponse
    ]("revokeInvitation", api.revokeInvitation)(request.buildAwsValue())
      .map(zio.aws.alexaforbusiness.model.RevokeInvitationResponse.wrap)
      .provideEnvironment(r)
    def listSkillsStoreCategories(
        request: ListSkillsStoreCategoriesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.alexaforbusiness.model.Category.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreCategoriesRequest,
      ListSkillsStoreCategoriesResponse,
      Category
    ](
      "listSkillsStoreCategories",
      api.listSkillsStoreCategories,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.categoryList().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.alexaforbusiness.model.Category.wrap(item))
      .provideEnvironment(r)
    def listSkillsStoreCategoriesPaginated(
        request: ListSkillsStoreCategoriesRequest
    ): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.ListSkillsStoreCategoriesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreCategoriesRequest,
      ListSkillsStoreCategoriesResponse
    ]("listSkillsStoreCategories", api.listSkillsStoreCategories)(
      request.buildAwsValue()
    ).map(zio.aws.alexaforbusiness.model.ListSkillsStoreCategoriesResponse.wrap)
      .provideEnvironment(r)
    def disassociateSkillFromSkillGroup(
        request: DisassociateSkillFromSkillGroupRequest
    ): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.DisassociateSkillFromSkillGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.DisassociateSkillFromSkillGroupRequest,
      DisassociateSkillFromSkillGroupResponse
    ]("disassociateSkillFromSkillGroup", api.disassociateSkillFromSkillGroup)(
      request.buildAwsValue()
    ).map(
      zio.aws.alexaforbusiness.model.DisassociateSkillFromSkillGroupResponse.wrap
    ).provideEnvironment(r)
    def getRoomSkillParameter(request: GetRoomSkillParameterRequest): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.GetRoomSkillParameterResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.GetRoomSkillParameterRequest,
      GetRoomSkillParameterResponse
    ]("getRoomSkillParameter", api.getRoomSkillParameter)(
      request.buildAwsValue()
    ).map(zio.aws.alexaforbusiness.model.GetRoomSkillParameterResponse.wrap)
      .provideEnvironment(r)
    def updateNetworkProfile(request: UpdateNetworkProfileRequest): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.UpdateNetworkProfileResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.UpdateNetworkProfileRequest,
      UpdateNetworkProfileResponse
    ]("updateNetworkProfile", api.updateNetworkProfile)(request.buildAwsValue())
      .map(zio.aws.alexaforbusiness.model.UpdateNetworkProfileResponse.wrap)
      .provideEnvironment(r)
    def associateContactWithAddressBook(
        request: AssociateContactWithAddressBookRequest
    ): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.AssociateContactWithAddressBookResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.AssociateContactWithAddressBookRequest,
      AssociateContactWithAddressBookResponse
    ]("associateContactWithAddressBook", api.associateContactWithAddressBook)(
      request.buildAwsValue()
    ).map(
      zio.aws.alexaforbusiness.model.AssociateContactWithAddressBookResponse.wrap
    ).provideEnvironment(r)
    def listConferenceProviders(
        request: ListConferenceProvidersRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.alexaforbusiness.model.ConferenceProvider.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.alexaforbusiness.model.ListConferenceProvidersRequest,
      ListConferenceProvidersResponse,
      ConferenceProvider
    ](
      "listConferenceProviders",
      api.listConferenceProviders,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.conferenceProviders().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.alexaforbusiness.model.ConferenceProvider.wrap(item))
      .provideEnvironment(r)
    def listConferenceProvidersPaginated(
        request: ListConferenceProvidersRequest
    ): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.ListConferenceProvidersResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.ListConferenceProvidersRequest,
      ListConferenceProvidersResponse
    ]("listConferenceProviders", api.listConferenceProviders)(
      request.buildAwsValue()
    ).map(zio.aws.alexaforbusiness.model.ListConferenceProvidersResponse.wrap)
      .provideEnvironment(r)
    def listSkillsStoreSkillsByCategory(
        request: ListSkillsStoreSkillsByCategoryRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.alexaforbusiness.model.SkillsStoreSkill.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreSkillsByCategoryRequest,
      ListSkillsStoreSkillsByCategoryResponse,
      SkillsStoreSkill
    ](
      "listSkillsStoreSkillsByCategory",
      api.listSkillsStoreSkillsByCategory,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.skillsStoreSkills().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.alexaforbusiness.model.SkillsStoreSkill.wrap(item))
      .provideEnvironment(r)
    def listSkillsStoreSkillsByCategoryPaginated(
        request: ListSkillsStoreSkillsByCategoryRequest
    ): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.ListSkillsStoreSkillsByCategoryResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreSkillsByCategoryRequest,
      ListSkillsStoreSkillsByCategoryResponse
    ]("listSkillsStoreSkillsByCategory", api.listSkillsStoreSkillsByCategory)(
      request.buildAwsValue()
    ).map(
      zio.aws.alexaforbusiness.model.ListSkillsStoreSkillsByCategoryResponse.wrap
    ).provideEnvironment(r)
    def listTags(
        request: ListTagsRequest
    ): ZStream[Any, AwsError, zio.aws.alexaforbusiness.model.Tag.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.alexaforbusiness.model.ListTagsRequest,
        ListTagsResponse,
        Tag
      ](
        "listTags",
        api.listTags,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.tags().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.alexaforbusiness.model.Tag.wrap(item))
        .provideEnvironment(r)
    def listTagsPaginated(
        request: ListTagsRequest
    ): IO[AwsError, zio.aws.alexaforbusiness.model.ListTagsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.alexaforbusiness.model.ListTagsRequest,
        ListTagsResponse
      ]("listTags", api.listTags)(request.buildAwsValue())
        .map(zio.aws.alexaforbusiness.model.ListTagsResponse.wrap)
        .provideEnvironment(r)
    def deleteAddressBook(request: DeleteAddressBookRequest): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.DeleteAddressBookResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.DeleteAddressBookRequest,
      DeleteAddressBookResponse
    ]("deleteAddressBook", api.deleteAddressBook)(request.buildAwsValue())
      .map(zio.aws.alexaforbusiness.model.DeleteAddressBookResponse.wrap)
      .provideEnvironment(r)
    def createConferenceProvider(request: CreateConferenceProviderRequest): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.CreateConferenceProviderResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.CreateConferenceProviderRequest,
      CreateConferenceProviderResponse
    ]("createConferenceProvider", api.createConferenceProvider)(
      request.buildAwsValue()
    ).map(zio.aws.alexaforbusiness.model.CreateConferenceProviderResponse.wrap)
      .provideEnvironment(r)
    def deleteDevice(request: DeleteDeviceRequest): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.DeleteDeviceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.DeleteDeviceRequest,
      DeleteDeviceResponse
    ]("deleteDevice", api.deleteDevice)(request.buildAwsValue())
      .map(zio.aws.alexaforbusiness.model.DeleteDeviceResponse.wrap)
      .provideEnvironment(r)
    def createGatewayGroup(request: CreateGatewayGroupRequest): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.CreateGatewayGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.CreateGatewayGroupRequest,
      CreateGatewayGroupResponse
    ]("createGatewayGroup", api.createGatewayGroup)(request.buildAwsValue())
      .map(zio.aws.alexaforbusiness.model.CreateGatewayGroupResponse.wrap)
      .provideEnvironment(r)
    def getGatewayGroup(request: GetGatewayGroupRequest): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.GetGatewayGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.GetGatewayGroupRequest,
      GetGatewayGroupResponse
    ]("getGatewayGroup", api.getGatewayGroup)(request.buildAwsValue())
      .map(zio.aws.alexaforbusiness.model.GetGatewayGroupResponse.wrap)
      .provideEnvironment(r)
    def updateRoom(request: UpdateRoomRequest): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.UpdateRoomResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.UpdateRoomRequest,
      UpdateRoomResponse
    ]("updateRoom", api.updateRoom)(request.buildAwsValue())
      .map(zio.aws.alexaforbusiness.model.UpdateRoomResponse.wrap)
      .provideEnvironment(r)
    def deleteContact(request: DeleteContactRequest): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.DeleteContactResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.DeleteContactRequest,
      DeleteContactResponse
    ]("deleteContact", api.deleteContact)(request.buildAwsValue())
      .map(zio.aws.alexaforbusiness.model.DeleteContactResponse.wrap)
      .provideEnvironment(r)
    def updateBusinessReportSchedule(
        request: UpdateBusinessReportScheduleRequest
    ): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.UpdateBusinessReportScheduleResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.UpdateBusinessReportScheduleRequest,
      UpdateBusinessReportScheduleResponse
    ]("updateBusinessReportSchedule", api.updateBusinessReportSchedule)(
      request.buildAwsValue()
    ).map(
      zio.aws.alexaforbusiness.model.UpdateBusinessReportScheduleResponse.wrap
    ).provideEnvironment(r)
    def associateDeviceWithNetworkProfile(
        request: AssociateDeviceWithNetworkProfileRequest
    ): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.AssociateDeviceWithNetworkProfileResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.AssociateDeviceWithNetworkProfileRequest,
      AssociateDeviceWithNetworkProfileResponse
    ](
      "associateDeviceWithNetworkProfile",
      api.associateDeviceWithNetworkProfile
    )(request.buildAwsValue())
      .map(
        zio.aws.alexaforbusiness.model.AssociateDeviceWithNetworkProfileResponse.wrap
      )
      .provideEnvironment(r)
    def createContact(request: CreateContactRequest): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.CreateContactResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.CreateContactRequest,
      CreateContactResponse
    ]("createContact", api.createContact)(request.buildAwsValue())
      .map(zio.aws.alexaforbusiness.model.CreateContactResponse.wrap)
      .provideEnvironment(r)
    def putSkillAuthorization(request: PutSkillAuthorizationRequest): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.PutSkillAuthorizationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.PutSkillAuthorizationRequest,
      PutSkillAuthorizationResponse
    ]("putSkillAuthorization", api.putSkillAuthorization)(
      request.buildAwsValue()
    ).map(zio.aws.alexaforbusiness.model.PutSkillAuthorizationResponse.wrap)
      .provideEnvironment(r)
    def createAddressBook(request: CreateAddressBookRequest): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.CreateAddressBookResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.CreateAddressBookRequest,
      CreateAddressBookResponse
    ]("createAddressBook", api.createAddressBook)(request.buildAwsValue())
      .map(zio.aws.alexaforbusiness.model.CreateAddressBookResponse.wrap)
      .provideEnvironment(r)
    def updateConferenceProvider(request: UpdateConferenceProviderRequest): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.UpdateConferenceProviderResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.UpdateConferenceProviderRequest,
      UpdateConferenceProviderResponse
    ]("updateConferenceProvider", api.updateConferenceProvider)(
      request.buildAwsValue()
    ).map(zio.aws.alexaforbusiness.model.UpdateConferenceProviderResponse.wrap)
      .provideEnvironment(r)
    def listDeviceEvents(request: ListDeviceEventsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.alexaforbusiness.model.DeviceEvent.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.alexaforbusiness.model.ListDeviceEventsRequest,
      ListDeviceEventsResponse,
      DeviceEvent
    ](
      "listDeviceEvents",
      api.listDeviceEvents,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.deviceEvents().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.alexaforbusiness.model.DeviceEvent.wrap(item))
      .provideEnvironment(r)
    def listDeviceEventsPaginated(request: ListDeviceEventsRequest): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.ListDeviceEventsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.ListDeviceEventsRequest,
      ListDeviceEventsResponse
    ]("listDeviceEvents", api.listDeviceEvents)(request.buildAwsValue())
      .map(zio.aws.alexaforbusiness.model.ListDeviceEventsResponse.wrap)
      .provideEnvironment(r)
    def sendInvitation(request: SendInvitationRequest): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.SendInvitationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.SendInvitationRequest,
      SendInvitationResponse
    ]("sendInvitation", api.sendInvitation)(request.buildAwsValue())
      .map(zio.aws.alexaforbusiness.model.SendInvitationResponse.wrap)
      .provideEnvironment(r)
    def getConferenceProvider(request: GetConferenceProviderRequest): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.GetConferenceProviderResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.GetConferenceProviderRequest,
      GetConferenceProviderResponse
    ]("getConferenceProvider", api.getConferenceProvider)(
      request.buildAwsValue()
    ).map(zio.aws.alexaforbusiness.model.GetConferenceProviderResponse.wrap)
      .provideEnvironment(r)
    def getNetworkProfile(request: GetNetworkProfileRequest): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.GetNetworkProfileResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.GetNetworkProfileRequest,
      GetNetworkProfileResponse
    ]("getNetworkProfile", api.getNetworkProfile)(request.buildAwsValue())
      .map(zio.aws.alexaforbusiness.model.GetNetworkProfileResponse.wrap)
      .provideEnvironment(r)
    def disassociateDeviceFromRoom(
        request: DisassociateDeviceFromRoomRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.DisassociateDeviceFromRoomRequest,
      DisassociateDeviceFromRoomResponse
    ]("disassociateDeviceFromRoom", api.disassociateDeviceFromRoom)(
      request.buildAwsValue()
    ).map(
      zio.aws.alexaforbusiness.model.DisassociateDeviceFromRoomResponse.wrap
    ).provideEnvironment(r)
    def getSkillGroup(request: GetSkillGroupRequest): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.GetSkillGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.GetSkillGroupRequest,
      GetSkillGroupResponse
    ]("getSkillGroup", api.getSkillGroup)(request.buildAwsValue())
      .map(zio.aws.alexaforbusiness.model.GetSkillGroupResponse.wrap)
      .provideEnvironment(r)
    def approveSkill(request: ApproveSkillRequest): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.ApproveSkillResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.ApproveSkillRequest,
      ApproveSkillResponse
    ]("approveSkill", api.approveSkill)(request.buildAwsValue())
      .map(zio.aws.alexaforbusiness.model.ApproveSkillResponse.wrap)
      .provideEnvironment(r)
    def listSkills(request: ListSkillsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.alexaforbusiness.model.SkillSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsRequest,
      ListSkillsResponse,
      SkillSummary
    ](
      "listSkills",
      api.listSkills,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.skillSummaries().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.alexaforbusiness.model.SkillSummary.wrap(item))
      .provideEnvironment(r)
    def listSkillsPaginated(request: ListSkillsRequest): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.ListSkillsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsRequest,
      ListSkillsResponse
    ]("listSkills", api.listSkills)(request.buildAwsValue())
      .map(zio.aws.alexaforbusiness.model.ListSkillsResponse.wrap)
      .provideEnvironment(r)
    def createUser(request: CreateUserRequest): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.CreateUserResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.CreateUserRequest,
      CreateUserResponse
    ]("createUser", api.createUser)(request.buildAwsValue())
      .map(zio.aws.alexaforbusiness.model.CreateUserResponse.wrap)
      .provideEnvironment(r)
    def updateSkillGroup(request: UpdateSkillGroupRequest): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.UpdateSkillGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.UpdateSkillGroupRequest,
      UpdateSkillGroupResponse
    ]("updateSkillGroup", api.updateSkillGroup)(request.buildAwsValue())
      .map(zio.aws.alexaforbusiness.model.UpdateSkillGroupResponse.wrap)
      .provideEnvironment(r)
    def deleteSkillGroup(request: DeleteSkillGroupRequest): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.DeleteSkillGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.DeleteSkillGroupRequest,
      DeleteSkillGroupResponse
    ]("deleteSkillGroup", api.deleteSkillGroup)(request.buildAwsValue())
      .map(zio.aws.alexaforbusiness.model.DeleteSkillGroupResponse.wrap)
      .provideEnvironment(r)
    def rejectSkill(request: RejectSkillRequest): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.RejectSkillResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.RejectSkillRequest,
      RejectSkillResponse
    ]("rejectSkill", api.rejectSkill)(request.buildAwsValue())
      .map(zio.aws.alexaforbusiness.model.RejectSkillResponse.wrap)
      .provideEnvironment(r)
    def deleteBusinessReportSchedule(
        request: DeleteBusinessReportScheduleRequest
    ): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.DeleteBusinessReportScheduleResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.DeleteBusinessReportScheduleRequest,
      DeleteBusinessReportScheduleResponse
    ]("deleteBusinessReportSchedule", api.deleteBusinessReportSchedule)(
      request.buildAwsValue()
    ).map(
      zio.aws.alexaforbusiness.model.DeleteBusinessReportScheduleResponse.wrap
    ).provideEnvironment(r)
    def getAddressBook(request: GetAddressBookRequest): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.GetAddressBookResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.GetAddressBookRequest,
      GetAddressBookResponse
    ]("getAddressBook", api.getAddressBook)(request.buildAwsValue())
      .map(zio.aws.alexaforbusiness.model.GetAddressBookResponse.wrap)
      .provideEnvironment(r)
    def putInvitationConfiguration(
        request: PutInvitationConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.PutInvitationConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.PutInvitationConfigurationRequest,
      PutInvitationConfigurationResponse
    ]("putInvitationConfiguration", api.putInvitationConfiguration)(
      request.buildAwsValue()
    ).map(
      zio.aws.alexaforbusiness.model.PutInvitationConfigurationResponse.wrap
    ).provideEnvironment(r)
    def listBusinessReportSchedules(
        request: ListBusinessReportSchedulesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.alexaforbusiness.model.BusinessReportSchedule.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.alexaforbusiness.model.ListBusinessReportSchedulesRequest,
      ListBusinessReportSchedulesResponse,
      BusinessReportSchedule
    ](
      "listBusinessReportSchedules",
      api.listBusinessReportSchedules,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.businessReportSchedules().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.alexaforbusiness.model.BusinessReportSchedule.wrap(item)
      )
      .provideEnvironment(r)
    def listBusinessReportSchedulesPaginated(
        request: ListBusinessReportSchedulesRequest
    ): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.ListBusinessReportSchedulesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.ListBusinessReportSchedulesRequest,
      ListBusinessReportSchedulesResponse
    ]("listBusinessReportSchedules", api.listBusinessReportSchedules)(
      request.buildAwsValue()
    ).map(
      zio.aws.alexaforbusiness.model.ListBusinessReportSchedulesResponse.wrap
    ).provideEnvironment(r)
    def listGatewayGroups(request: ListGatewayGroupsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.alexaforbusiness.model.GatewayGroupSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.alexaforbusiness.model.ListGatewayGroupsRequest,
      ListGatewayGroupsResponse,
      GatewayGroupSummary
    ](
      "listGatewayGroups",
      api.listGatewayGroups,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.gatewayGroups().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.alexaforbusiness.model.GatewayGroupSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listGatewayGroupsPaginated(request: ListGatewayGroupsRequest): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.ListGatewayGroupsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.ListGatewayGroupsRequest,
      ListGatewayGroupsResponse
    ]("listGatewayGroups", api.listGatewayGroups)(request.buildAwsValue())
      .map(zio.aws.alexaforbusiness.model.ListGatewayGroupsResponse.wrap)
      .provideEnvironment(r)
    def deleteProfile(request: DeleteProfileRequest): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.DeleteProfileResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.DeleteProfileRequest,
      DeleteProfileResponse
    ]("deleteProfile", api.deleteProfile)(request.buildAwsValue())
      .map(zio.aws.alexaforbusiness.model.DeleteProfileResponse.wrap)
      .provideEnvironment(r)
    def startSmartHomeApplianceDiscovery(
        request: StartSmartHomeApplianceDiscoveryRequest
    ): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.StartSmartHomeApplianceDiscoveryResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.StartSmartHomeApplianceDiscoveryRequest,
      StartSmartHomeApplianceDiscoveryResponse
    ]("startSmartHomeApplianceDiscovery", api.startSmartHomeApplianceDiscovery)(
      request.buildAwsValue()
    ).map(
      zio.aws.alexaforbusiness.model.StartSmartHomeApplianceDiscoveryResponse.wrap
    ).provideEnvironment(r)
    def sendAnnouncement(request: SendAnnouncementRequest): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.SendAnnouncementResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.SendAnnouncementRequest,
      SendAnnouncementResponse
    ]("sendAnnouncement", api.sendAnnouncement)(request.buildAwsValue())
      .map(zio.aws.alexaforbusiness.model.SendAnnouncementResponse.wrap)
      .provideEnvironment(r)
    def getInvitationConfiguration(
        request: GetInvitationConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.GetInvitationConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.GetInvitationConfigurationRequest,
      GetInvitationConfigurationResponse
    ]("getInvitationConfiguration", api.getInvitationConfiguration)(
      request.buildAwsValue()
    ).map(
      zio.aws.alexaforbusiness.model.GetInvitationConfigurationResponse.wrap
    ).provideEnvironment(r)
    def untagResource(request: UntagResourceRequest): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.UntagResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.UntagResourceRequest,
      UntagResourceResponse
    ]("untagResource", api.untagResource)(request.buildAwsValue())
      .map(zio.aws.alexaforbusiness.model.UntagResourceResponse.wrap)
      .provideEnvironment(r)
    def associateSkillGroupWithRoom(
        request: AssociateSkillGroupWithRoomRequest
    ): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.AssociateSkillGroupWithRoomResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.AssociateSkillGroupWithRoomRequest,
      AssociateSkillGroupWithRoomResponse
    ]("associateSkillGroupWithRoom", api.associateSkillGroupWithRoom)(
      request.buildAwsValue()
    ).map(
      zio.aws.alexaforbusiness.model.AssociateSkillGroupWithRoomResponse.wrap
    ).provideEnvironment(r)
    def disassociateSkillGroupFromRoom(
        request: DisassociateSkillGroupFromRoomRequest
    ): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.DisassociateSkillGroupFromRoomResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.DisassociateSkillGroupFromRoomRequest,
      DisassociateSkillGroupFromRoomResponse
    ]("disassociateSkillGroupFromRoom", api.disassociateSkillGroupFromRoom)(
      request.buildAwsValue()
    ).map(
      zio.aws.alexaforbusiness.model.DisassociateSkillGroupFromRoomResponse.wrap
    ).provideEnvironment(r)
    def startDeviceSync(request: StartDeviceSyncRequest): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.StartDeviceSyncResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.StartDeviceSyncRequest,
      StartDeviceSyncResponse
    ]("startDeviceSync", api.startDeviceSync)(request.buildAwsValue())
      .map(zio.aws.alexaforbusiness.model.StartDeviceSyncResponse.wrap)
      .provideEnvironment(r)
    def associateDeviceWithRoom(request: AssociateDeviceWithRoomRequest): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.AssociateDeviceWithRoomResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.AssociateDeviceWithRoomRequest,
      AssociateDeviceWithRoomResponse
    ]("associateDeviceWithRoom", api.associateDeviceWithRoom)(
      request.buildAwsValue()
    ).map(zio.aws.alexaforbusiness.model.AssociateDeviceWithRoomResponse.wrap)
      .provideEnvironment(r)
    def createRoom(request: CreateRoomRequest): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.CreateRoomResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.CreateRoomRequest,
      CreateRoomResponse
    ]("createRoom", api.createRoom)(request.buildAwsValue())
      .map(zio.aws.alexaforbusiness.model.CreateRoomResponse.wrap)
      .provideEnvironment(r)
    def deleteRoom(request: DeleteRoomRequest): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.DeleteRoomResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.DeleteRoomRequest,
      DeleteRoomResponse
    ]("deleteRoom", api.deleteRoom)(request.buildAwsValue())
      .map(zio.aws.alexaforbusiness.model.DeleteRoomResponse.wrap)
      .provideEnvironment(r)
    def getProfile(request: GetProfileRequest): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.GetProfileResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.GetProfileRequest,
      GetProfileResponse
    ]("getProfile", api.getProfile)(request.buildAwsValue())
      .map(zio.aws.alexaforbusiness.model.GetProfileResponse.wrap)
      .provideEnvironment(r)
    def forgetSmartHomeAppliances(
        request: ForgetSmartHomeAppliancesRequest
    ): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.ForgetSmartHomeAppliancesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.ForgetSmartHomeAppliancesRequest,
      ForgetSmartHomeAppliancesResponse
    ]("forgetSmartHomeAppliances", api.forgetSmartHomeAppliances)(
      request.buildAwsValue()
    ).map(zio.aws.alexaforbusiness.model.ForgetSmartHomeAppliancesResponse.wrap)
      .provideEnvironment(r)
    def getConferencePreference(request: GetConferencePreferenceRequest): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.GetConferencePreferenceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.GetConferencePreferenceRequest,
      GetConferencePreferenceResponse
    ]("getConferencePreference", api.getConferencePreference)(
      request.buildAwsValue()
    ).map(zio.aws.alexaforbusiness.model.GetConferencePreferenceResponse.wrap)
      .provideEnvironment(r)
    def updateAddressBook(request: UpdateAddressBookRequest): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.UpdateAddressBookResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.UpdateAddressBookRequest,
      UpdateAddressBookResponse
    ]("updateAddressBook", api.updateAddressBook)(request.buildAwsValue())
      .map(zio.aws.alexaforbusiness.model.UpdateAddressBookResponse.wrap)
      .provideEnvironment(r)
    def disassociateSkillFromUsers(
        request: DisassociateSkillFromUsersRequest
    ): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.DisassociateSkillFromUsersResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.DisassociateSkillFromUsersRequest,
      DisassociateSkillFromUsersResponse
    ]("disassociateSkillFromUsers", api.disassociateSkillFromUsers)(
      request.buildAwsValue()
    ).map(
      zio.aws.alexaforbusiness.model.DisassociateSkillFromUsersResponse.wrap
    ).provideEnvironment(r)
    def updateDevice(request: UpdateDeviceRequest): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.UpdateDeviceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.UpdateDeviceRequest,
      UpdateDeviceResponse
    ]("updateDevice", api.updateDevice)(request.buildAwsValue())
      .map(zio.aws.alexaforbusiness.model.UpdateDeviceResponse.wrap)
      .provideEnvironment(r)
    def searchRooms(
        request: SearchRoomsRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.alexaforbusiness.model.SearchRoomsResponse.ReadOnly,
      zio.aws.alexaforbusiness.model.RoomData.ReadOnly
    ]] = asyncPaginatedRequest[
      software.amazon.awssdk.services.alexaforbusiness.model.SearchRoomsRequest,
      SearchRoomsResponse,
      RoomData
    ](
      "searchRooms",
      api.searchRooms,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.rooms().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(zio.aws.alexaforbusiness.model.SearchRoomsResponse.wrap)
          .mapOutput(
            _.map(item => zio.aws.alexaforbusiness.model.RoomData.wrap(item))
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def searchRoomsPaginated(request: SearchRoomsRequest): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.SearchRoomsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.SearchRoomsRequest,
      SearchRoomsResponse
    ]("searchRooms", api.searchRooms)(request.buildAwsValue())
      .map(zio.aws.alexaforbusiness.model.SearchRoomsResponse.wrap)
      .provideEnvironment(r)
    def tagResource(request: TagResourceRequest): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.TagResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.TagResourceRequest,
      TagResourceResponse
    ]("tagResource", api.tagResource)(request.buildAwsValue())
      .map(zio.aws.alexaforbusiness.model.TagResourceResponse.wrap)
      .provideEnvironment(r)
    def disassociateContactFromAddressBook(
        request: DisassociateContactFromAddressBookRequest
    ): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.DisassociateContactFromAddressBookResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.DisassociateContactFromAddressBookRequest,
      DisassociateContactFromAddressBookResponse
    ](
      "disassociateContactFromAddressBook",
      api.disassociateContactFromAddressBook
    )(request.buildAwsValue())
      .map(
        zio.aws.alexaforbusiness.model.DisassociateContactFromAddressBookResponse.wrap
      )
      .provideEnvironment(r)
    def createProfile(request: CreateProfileRequest): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.CreateProfileResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.CreateProfileRequest,
      CreateProfileResponse
    ]("createProfile", api.createProfile)(request.buildAwsValue())
      .map(zio.aws.alexaforbusiness.model.CreateProfileResponse.wrap)
      .provideEnvironment(r)
    def deleteNetworkProfile(request: DeleteNetworkProfileRequest): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.DeleteNetworkProfileResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.DeleteNetworkProfileRequest,
      DeleteNetworkProfileResponse
    ]("deleteNetworkProfile", api.deleteNetworkProfile)(request.buildAwsValue())
      .map(zio.aws.alexaforbusiness.model.DeleteNetworkProfileResponse.wrap)
      .provideEnvironment(r)
    def listSmartHomeAppliances(
        request: ListSmartHomeAppliancesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.alexaforbusiness.model.SmartHomeAppliance.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.alexaforbusiness.model.ListSmartHomeAppliancesRequest,
      ListSmartHomeAppliancesResponse,
      SmartHomeAppliance
    ](
      "listSmartHomeAppliances",
      api.listSmartHomeAppliances,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.smartHomeAppliances().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.alexaforbusiness.model.SmartHomeAppliance.wrap(item))
      .provideEnvironment(r)
    def listSmartHomeAppliancesPaginated(
        request: ListSmartHomeAppliancesRequest
    ): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.ListSmartHomeAppliancesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.ListSmartHomeAppliancesRequest,
      ListSmartHomeAppliancesResponse
    ]("listSmartHomeAppliances", api.listSmartHomeAppliances)(
      request.buildAwsValue()
    ).map(zio.aws.alexaforbusiness.model.ListSmartHomeAppliancesResponse.wrap)
      .provideEnvironment(r)
    def getRoom(
        request: GetRoomRequest
    ): IO[AwsError, zio.aws.alexaforbusiness.model.GetRoomResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.alexaforbusiness.model.GetRoomRequest,
        GetRoomResponse
      ]("getRoom", api.getRoom)(request.buildAwsValue())
        .map(zio.aws.alexaforbusiness.model.GetRoomResponse.wrap)
        .provideEnvironment(r)
    def deleteUser(request: DeleteUserRequest): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.DeleteUserResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.DeleteUserRequest,
      DeleteUserResponse
    ]("deleteUser", api.deleteUser)(request.buildAwsValue())
      .map(zio.aws.alexaforbusiness.model.DeleteUserResponse.wrap)
      .provideEnvironment(r)
    def putConferencePreference(request: PutConferencePreferenceRequest): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.PutConferencePreferenceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.PutConferencePreferenceRequest,
      PutConferencePreferenceResponse
    ]("putConferencePreference", api.putConferencePreference)(
      request.buildAwsValue()
    ).map(zio.aws.alexaforbusiness.model.PutConferencePreferenceResponse.wrap)
      .provideEnvironment(r)
    def deleteGatewayGroup(request: DeleteGatewayGroupRequest): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.DeleteGatewayGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.DeleteGatewayGroupRequest,
      DeleteGatewayGroupResponse
    ]("deleteGatewayGroup", api.deleteGatewayGroup)(request.buildAwsValue())
      .map(zio.aws.alexaforbusiness.model.DeleteGatewayGroupResponse.wrap)
      .provideEnvironment(r)
    def searchDevices(
        request: SearchDevicesRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.alexaforbusiness.model.SearchDevicesResponse.ReadOnly,
      zio.aws.alexaforbusiness.model.DeviceData.ReadOnly
    ]] = asyncPaginatedRequest[
      software.amazon.awssdk.services.alexaforbusiness.model.SearchDevicesRequest,
      SearchDevicesResponse,
      DeviceData
    ](
      "searchDevices",
      api.searchDevices,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.devices().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(
            zio.aws.alexaforbusiness.model.SearchDevicesResponse.wrap
          )
          .mapOutput(
            _.map(item => zio.aws.alexaforbusiness.model.DeviceData.wrap(item))
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def searchDevicesPaginated(request: SearchDevicesRequest): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.SearchDevicesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.SearchDevicesRequest,
      SearchDevicesResponse
    ]("searchDevices", api.searchDevices)(request.buildAwsValue())
      .map(zio.aws.alexaforbusiness.model.SearchDevicesResponse.wrap)
      .provideEnvironment(r)
    def getContact(request: GetContactRequest): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.GetContactResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.GetContactRequest,
      GetContactResponse
    ]("getContact", api.getContact)(request.buildAwsValue())
      .map(zio.aws.alexaforbusiness.model.GetContactResponse.wrap)
      .provideEnvironment(r)
    def resolveRoom(request: ResolveRoomRequest): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.ResolveRoomResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.ResolveRoomRequest,
      ResolveRoomResponse
    ]("resolveRoom", api.resolveRoom)(request.buildAwsValue())
      .map(zio.aws.alexaforbusiness.model.ResolveRoomResponse.wrap)
      .provideEnvironment(r)
    def registerAVSDevice(request: RegisterAvsDeviceRequest): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.RegisterAvsDeviceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.RegisterAvsDeviceRequest,
      RegisterAvsDeviceResponse
    ]("registerAVSDevice", api.registerAVSDevice)(request.buildAwsValue())
      .map(zio.aws.alexaforbusiness.model.RegisterAvsDeviceResponse.wrap)
      .provideEnvironment(r)
    def updateProfile(request: UpdateProfileRequest): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.UpdateProfileResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.UpdateProfileRequest,
      UpdateProfileResponse
    ]("updateProfile", api.updateProfile)(request.buildAwsValue())
      .map(zio.aws.alexaforbusiness.model.UpdateProfileResponse.wrap)
      .provideEnvironment(r)
    def createSkillGroup(request: CreateSkillGroupRequest): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.CreateSkillGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.CreateSkillGroupRequest,
      CreateSkillGroupResponse
    ]("createSkillGroup", api.createSkillGroup)(request.buildAwsValue())
      .map(zio.aws.alexaforbusiness.model.CreateSkillGroupResponse.wrap)
      .provideEnvironment(r)
    def searchProfiles(
        request: SearchProfilesRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.alexaforbusiness.model.SearchProfilesResponse.ReadOnly,
      zio.aws.alexaforbusiness.model.ProfileData.ReadOnly
    ]] = asyncPaginatedRequest[
      software.amazon.awssdk.services.alexaforbusiness.model.SearchProfilesRequest,
      SearchProfilesResponse,
      ProfileData
    ](
      "searchProfiles",
      api.searchProfiles,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.profiles().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(
            zio.aws.alexaforbusiness.model.SearchProfilesResponse.wrap
          )
          .mapOutput(
            _.map(item => zio.aws.alexaforbusiness.model.ProfileData.wrap(item))
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def searchProfilesPaginated(request: SearchProfilesRequest): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.SearchProfilesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.SearchProfilesRequest,
      SearchProfilesResponse
    ]("searchProfiles", api.searchProfiles)(request.buildAwsValue())
      .map(zio.aws.alexaforbusiness.model.SearchProfilesResponse.wrap)
      .provideEnvironment(r)
    def deleteDeviceUsageData(request: DeleteDeviceUsageDataRequest): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.DeleteDeviceUsageDataResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.DeleteDeviceUsageDataRequest,
      DeleteDeviceUsageDataResponse
    ]("deleteDeviceUsageData", api.deleteDeviceUsageData)(
      request.buildAwsValue()
    ).map(zio.aws.alexaforbusiness.model.DeleteDeviceUsageDataResponse.wrap)
      .provideEnvironment(r)
    def searchContacts(
        request: SearchContactsRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.alexaforbusiness.model.SearchContactsResponse.ReadOnly,
      zio.aws.alexaforbusiness.model.ContactData.ReadOnly
    ]] = asyncPaginatedRequest[
      software.amazon.awssdk.services.alexaforbusiness.model.SearchContactsRequest,
      SearchContactsResponse,
      ContactData
    ](
      "searchContacts",
      api.searchContacts,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.contacts().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(
            zio.aws.alexaforbusiness.model.SearchContactsResponse.wrap
          )
          .mapOutput(
            _.map(item => zio.aws.alexaforbusiness.model.ContactData.wrap(item))
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def searchContactsPaginated(request: SearchContactsRequest): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.SearchContactsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.SearchContactsRequest,
      SearchContactsResponse
    ]("searchContacts", api.searchContacts)(request.buildAwsValue())
      .map(zio.aws.alexaforbusiness.model.SearchContactsResponse.wrap)
      .provideEnvironment(r)
    def getDevice(
        request: GetDeviceRequest
    ): IO[AwsError, zio.aws.alexaforbusiness.model.GetDeviceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.alexaforbusiness.model.GetDeviceRequest,
        GetDeviceResponse
      ]("getDevice", api.getDevice)(request.buildAwsValue())
        .map(zio.aws.alexaforbusiness.model.GetDeviceResponse.wrap)
        .provideEnvironment(r)
    def createNetworkProfile(request: CreateNetworkProfileRequest): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.CreateNetworkProfileResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.CreateNetworkProfileRequest,
      CreateNetworkProfileResponse
    ]("createNetworkProfile", api.createNetworkProfile)(request.buildAwsValue())
      .map(zio.aws.alexaforbusiness.model.CreateNetworkProfileResponse.wrap)
      .provideEnvironment(r)
    def createBusinessReportSchedule(
        request: CreateBusinessReportScheduleRequest
    ): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.CreateBusinessReportScheduleResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.CreateBusinessReportScheduleRequest,
      CreateBusinessReportScheduleResponse
    ]("createBusinessReportSchedule", api.createBusinessReportSchedule)(
      request.buildAwsValue()
    ).map(
      zio.aws.alexaforbusiness.model.CreateBusinessReportScheduleResponse.wrap
    ).provideEnvironment(r)
    def getGateway(request: GetGatewayRequest): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.GetGatewayResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.GetGatewayRequest,
      GetGatewayResponse
    ]("getGateway", api.getGateway)(request.buildAwsValue())
      .map(zio.aws.alexaforbusiness.model.GetGatewayResponse.wrap)
      .provideEnvironment(r)
    def searchNetworkProfiles(
        request: SearchNetworkProfilesRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.alexaforbusiness.model.SearchNetworkProfilesResponse.ReadOnly,
      zio.aws.alexaforbusiness.model.NetworkProfileData.ReadOnly
    ]] = asyncPaginatedRequest[
      software.amazon.awssdk.services.alexaforbusiness.model.SearchNetworkProfilesRequest,
      SearchNetworkProfilesResponse,
      NetworkProfileData
    ](
      "searchNetworkProfiles",
      api.searchNetworkProfiles,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.networkProfiles().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(
            zio.aws.alexaforbusiness.model.SearchNetworkProfilesResponse.wrap
          )
          .mapOutput(
            _.map(item =>
              zio.aws.alexaforbusiness.model.NetworkProfileData.wrap(item)
            )
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def searchNetworkProfilesPaginated(
        request: SearchNetworkProfilesRequest
    ): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.SearchNetworkProfilesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.SearchNetworkProfilesRequest,
      SearchNetworkProfilesResponse
    ]("searchNetworkProfiles", api.searchNetworkProfiles)(
      request.buildAwsValue()
    ).map(zio.aws.alexaforbusiness.model.SearchNetworkProfilesResponse.wrap)
      .provideEnvironment(r)
    def searchAddressBooks(
        request: SearchAddressBooksRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.alexaforbusiness.model.SearchAddressBooksResponse.ReadOnly,
      zio.aws.alexaforbusiness.model.AddressBookData.ReadOnly
    ]] = asyncPaginatedRequest[
      software.amazon.awssdk.services.alexaforbusiness.model.SearchAddressBooksRequest,
      SearchAddressBooksResponse,
      AddressBookData
    ](
      "searchAddressBooks",
      api.searchAddressBooks,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.addressBooks().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(
            zio.aws.alexaforbusiness.model.SearchAddressBooksResponse.wrap
          )
          .mapOutput(
            _.map(item =>
              zio.aws.alexaforbusiness.model.AddressBookData.wrap(item)
            )
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def searchAddressBooksPaginated(request: SearchAddressBooksRequest): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.SearchAddressBooksResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.SearchAddressBooksRequest,
      SearchAddressBooksResponse
    ]("searchAddressBooks", api.searchAddressBooks)(request.buildAwsValue())
      .map(zio.aws.alexaforbusiness.model.SearchAddressBooksResponse.wrap)
      .provideEnvironment(r)
    def putRoomSkillParameter(request: PutRoomSkillParameterRequest): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.PutRoomSkillParameterResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.PutRoomSkillParameterRequest,
      PutRoomSkillParameterResponse
    ]("putRoomSkillParameter", api.putRoomSkillParameter)(
      request.buildAwsValue()
    ).map(zio.aws.alexaforbusiness.model.PutRoomSkillParameterResponse.wrap)
      .provideEnvironment(r)
    def listGateways(request: ListGatewaysRequest): ZStream[
      Any,
      AwsError,
      zio.aws.alexaforbusiness.model.GatewaySummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.alexaforbusiness.model.ListGatewaysRequest,
      ListGatewaysResponse,
      GatewaySummary
    ](
      "listGateways",
      api.listGateways,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.gateways().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.alexaforbusiness.model.GatewaySummary.wrap(item))
      .provideEnvironment(r)
    def listGatewaysPaginated(request: ListGatewaysRequest): IO[
      AwsError,
      zio.aws.alexaforbusiness.model.ListGatewaysResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.ListGatewaysRequest,
      ListGatewaysResponse
    ]("listGateways", api.listGateways)(request.buildAwsValue())
      .map(zio.aws.alexaforbusiness.model.ListGatewaysResponse.wrap)
      .provideEnvironment(r)
  }
  def updateContact(request: UpdateContactRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.UpdateContactResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateContact(request))
  def deleteRoomSkillParameter(request: DeleteRoomSkillParameterRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.DeleteRoomSkillParameterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteRoomSkillParameter(request))
  def associateSkillWithUsers(request: AssociateSkillWithUsersRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.AssociateSkillWithUsersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateSkillWithUsers(request))
  def deleteSkillAuthorization(request: DeleteSkillAuthorizationRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.DeleteSkillAuthorizationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteSkillAuthorization(request))
  def deleteConferenceProvider(request: DeleteConferenceProviderRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.DeleteConferenceProviderResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteConferenceProvider(request))
  def updateGateway(request: UpdateGatewayRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.UpdateGatewayResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateGateway(request))
  def updateGatewayGroup(request: UpdateGatewayGroupRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.UpdateGatewayGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateGatewayGroup(request))
  def searchUsers(request: SearchUsersRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    StreamingOutputResult[
      Any,
      zio.aws.alexaforbusiness.model.SearchUsersResponse.ReadOnly,
      zio.aws.alexaforbusiness.model.UserData.ReadOnly
    ]
  ] = ZIO.serviceWithZIO(_.searchUsers(request))
  def searchUsersPaginated(request: SearchUsersRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.SearchUsersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.searchUsersPaginated(request))
  def searchSkillGroups(request: SearchSkillGroupsRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    StreamingOutputResult[
      Any,
      zio.aws.alexaforbusiness.model.SearchSkillGroupsResponse.ReadOnly,
      zio.aws.alexaforbusiness.model.SkillGroupData.ReadOnly
    ]
  ] = ZIO.serviceWithZIO(_.searchSkillGroups(request))
  def searchSkillGroupsPaginated(request: SearchSkillGroupsRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.SearchSkillGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.searchSkillGroupsPaginated(request))
  def associateSkillWithSkillGroup(
      request: AssociateSkillWithSkillGroupRequest
  ): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.AssociateSkillWithSkillGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateSkillWithSkillGroup(request))
  def revokeInvitation(request: RevokeInvitationRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.RevokeInvitationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.revokeInvitation(request))
  def listSkillsStoreCategories(
      request: ListSkillsStoreCategoriesRequest
  ): ZStream[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.Category.ReadOnly
  ] = ZStream.serviceWithStream(_.listSkillsStoreCategories(request))
  def listSkillsStoreCategoriesPaginated(
      request: ListSkillsStoreCategoriesRequest
  ): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.ListSkillsStoreCategoriesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSkillsStoreCategoriesPaginated(request))
  def disassociateSkillFromSkillGroup(
      request: DisassociateSkillFromSkillGroupRequest
  ): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.DisassociateSkillFromSkillGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateSkillFromSkillGroup(request))
  def getRoomSkillParameter(request: GetRoomSkillParameterRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.GetRoomSkillParameterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getRoomSkillParameter(request))
  def updateNetworkProfile(request: UpdateNetworkProfileRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.UpdateNetworkProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateNetworkProfile(request))
  def associateContactWithAddressBook(
      request: AssociateContactWithAddressBookRequest
  ): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.AssociateContactWithAddressBookResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateContactWithAddressBook(request))
  def listConferenceProviders(request: ListConferenceProvidersRequest): ZStream[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.ConferenceProvider.ReadOnly
  ] = ZStream.serviceWithStream(_.listConferenceProviders(request))
  def listConferenceProvidersPaginated(
      request: ListConferenceProvidersRequest
  ): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.ListConferenceProvidersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listConferenceProvidersPaginated(request))
  def listSkillsStoreSkillsByCategory(
      request: ListSkillsStoreSkillsByCategoryRequest
  ): ZStream[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.SkillsStoreSkill.ReadOnly
  ] = ZStream.serviceWithStream(_.listSkillsStoreSkillsByCategory(request))
  def listSkillsStoreSkillsByCategoryPaginated(
      request: ListSkillsStoreSkillsByCategoryRequest
  ): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.ListSkillsStoreSkillsByCategoryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSkillsStoreSkillsByCategoryPaginated(request))
  def listTags(request: ListTagsRequest): ZStream[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.Tag.ReadOnly
  ] = ZStream.serviceWithStream(_.listTags(request))
  def listTagsPaginated(request: ListTagsRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.ListTagsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsPaginated(request))
  def deleteAddressBook(request: DeleteAddressBookRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.DeleteAddressBookResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteAddressBook(request))
  def createConferenceProvider(request: CreateConferenceProviderRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.CreateConferenceProviderResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createConferenceProvider(request))
  def deleteDevice(request: DeleteDeviceRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.DeleteDeviceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDevice(request))
  def createGatewayGroup(request: CreateGatewayGroupRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.CreateGatewayGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createGatewayGroup(request))
  def getGatewayGroup(request: GetGatewayGroupRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.GetGatewayGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getGatewayGroup(request))
  def updateRoom(request: UpdateRoomRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.UpdateRoomResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateRoom(request))
  def deleteContact(request: DeleteContactRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.DeleteContactResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteContact(request))
  def updateBusinessReportSchedule(
      request: UpdateBusinessReportScheduleRequest
  ): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.UpdateBusinessReportScheduleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateBusinessReportSchedule(request))
  def associateDeviceWithNetworkProfile(
      request: AssociateDeviceWithNetworkProfileRequest
  ): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.AssociateDeviceWithNetworkProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateDeviceWithNetworkProfile(request))
  def createContact(request: CreateContactRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.CreateContactResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createContact(request))
  def putSkillAuthorization(request: PutSkillAuthorizationRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.PutSkillAuthorizationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putSkillAuthorization(request))
  def createAddressBook(request: CreateAddressBookRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.CreateAddressBookResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createAddressBook(request))
  def updateConferenceProvider(request: UpdateConferenceProviderRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.UpdateConferenceProviderResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateConferenceProvider(request))
  def listDeviceEvents(request: ListDeviceEventsRequest): ZStream[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.DeviceEvent.ReadOnly
  ] = ZStream.serviceWithStream(_.listDeviceEvents(request))
  def listDeviceEventsPaginated(request: ListDeviceEventsRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.ListDeviceEventsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDeviceEventsPaginated(request))
  def sendInvitation(request: SendInvitationRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.SendInvitationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.sendInvitation(request))
  def getConferenceProvider(request: GetConferenceProviderRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.GetConferenceProviderResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getConferenceProvider(request))
  def getNetworkProfile(request: GetNetworkProfileRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.GetNetworkProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getNetworkProfile(request))
  def disassociateDeviceFromRoom(
      request: DisassociateDeviceFromRoomRequest
  ): ZIO[zio.aws.alexaforbusiness.AlexaForBusiness, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.disassociateDeviceFromRoom(request))
  def getSkillGroup(request: GetSkillGroupRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.GetSkillGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSkillGroup(request))
  def approveSkill(request: ApproveSkillRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.ApproveSkillResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.approveSkill(request))
  def listSkills(request: ListSkillsRequest): ZStream[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.SkillSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listSkills(request))
  def listSkillsPaginated(request: ListSkillsRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.ListSkillsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSkillsPaginated(request))
  def createUser(request: CreateUserRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.CreateUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createUser(request))
  def updateSkillGroup(request: UpdateSkillGroupRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.UpdateSkillGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateSkillGroup(request))
  def deleteSkillGroup(request: DeleteSkillGroupRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.DeleteSkillGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteSkillGroup(request))
  def rejectSkill(request: RejectSkillRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.RejectSkillResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.rejectSkill(request))
  def deleteBusinessReportSchedule(
      request: DeleteBusinessReportScheduleRequest
  ): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.DeleteBusinessReportScheduleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteBusinessReportSchedule(request))
  def getAddressBook(request: GetAddressBookRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.GetAddressBookResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAddressBook(request))
  def putInvitationConfiguration(
      request: PutInvitationConfigurationRequest
  ): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.PutInvitationConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putInvitationConfiguration(request))
  def listBusinessReportSchedules(
      request: ListBusinessReportSchedulesRequest
  ): ZStream[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.BusinessReportSchedule.ReadOnly
  ] = ZStream.serviceWithStream(_.listBusinessReportSchedules(request))
  def listBusinessReportSchedulesPaginated(
      request: ListBusinessReportSchedulesRequest
  ): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.ListBusinessReportSchedulesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listBusinessReportSchedulesPaginated(request))
  def listGatewayGroups(request: ListGatewayGroupsRequest): ZStream[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.GatewayGroupSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listGatewayGroups(request))
  def listGatewayGroupsPaginated(request: ListGatewayGroupsRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.ListGatewayGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listGatewayGroupsPaginated(request))
  def deleteProfile(request: DeleteProfileRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.DeleteProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteProfile(request))
  def startSmartHomeApplianceDiscovery(
      request: StartSmartHomeApplianceDiscoveryRequest
  ): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.StartSmartHomeApplianceDiscoveryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startSmartHomeApplianceDiscovery(request))
  def sendAnnouncement(request: SendAnnouncementRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.SendAnnouncementResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.sendAnnouncement(request))
  def getInvitationConfiguration(
      request: GetInvitationConfigurationRequest
  ): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.GetInvitationConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getInvitationConfiguration(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def associateSkillGroupWithRoom(
      request: AssociateSkillGroupWithRoomRequest
  ): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.AssociateSkillGroupWithRoomResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateSkillGroupWithRoom(request))
  def disassociateSkillGroupFromRoom(
      request: DisassociateSkillGroupFromRoomRequest
  ): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.DisassociateSkillGroupFromRoomResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateSkillGroupFromRoom(request))
  def startDeviceSync(request: StartDeviceSyncRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.StartDeviceSyncResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startDeviceSync(request))
  def associateDeviceWithRoom(request: AssociateDeviceWithRoomRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.AssociateDeviceWithRoomResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateDeviceWithRoom(request))
  def createRoom(request: CreateRoomRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.CreateRoomResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createRoom(request))
  def deleteRoom(request: DeleteRoomRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.DeleteRoomResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteRoom(request))
  def getProfile(request: GetProfileRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.GetProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getProfile(request))
  def forgetSmartHomeAppliances(request: ForgetSmartHomeAppliancesRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.ForgetSmartHomeAppliancesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.forgetSmartHomeAppliances(request))
  def getConferencePreference(request: GetConferencePreferenceRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.GetConferencePreferenceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getConferencePreference(request))
  def updateAddressBook(request: UpdateAddressBookRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.UpdateAddressBookResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateAddressBook(request))
  def disassociateSkillFromUsers(
      request: DisassociateSkillFromUsersRequest
  ): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.DisassociateSkillFromUsersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateSkillFromUsers(request))
  def updateDevice(request: UpdateDeviceRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.UpdateDeviceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateDevice(request))
  def searchRooms(request: SearchRoomsRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    StreamingOutputResult[
      Any,
      zio.aws.alexaforbusiness.model.SearchRoomsResponse.ReadOnly,
      zio.aws.alexaforbusiness.model.RoomData.ReadOnly
    ]
  ] = ZIO.serviceWithZIO(_.searchRooms(request))
  def searchRoomsPaginated(request: SearchRoomsRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.SearchRoomsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.searchRoomsPaginated(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def disassociateContactFromAddressBook(
      request: DisassociateContactFromAddressBookRequest
  ): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.DisassociateContactFromAddressBookResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateContactFromAddressBook(request))
  def createProfile(request: CreateProfileRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.CreateProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createProfile(request))
  def deleteNetworkProfile(request: DeleteNetworkProfileRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.DeleteNetworkProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteNetworkProfile(request))
  def listSmartHomeAppliances(request: ListSmartHomeAppliancesRequest): ZStream[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.SmartHomeAppliance.ReadOnly
  ] = ZStream.serviceWithStream(_.listSmartHomeAppliances(request))
  def listSmartHomeAppliancesPaginated(
      request: ListSmartHomeAppliancesRequest
  ): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.ListSmartHomeAppliancesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSmartHomeAppliancesPaginated(request))
  def getRoom(request: GetRoomRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.GetRoomResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getRoom(request))
  def deleteUser(request: DeleteUserRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.DeleteUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteUser(request))
  def putConferencePreference(request: PutConferencePreferenceRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.PutConferencePreferenceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putConferencePreference(request))
  def deleteGatewayGroup(request: DeleteGatewayGroupRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.DeleteGatewayGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteGatewayGroup(request))
  def searchDevices(request: SearchDevicesRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    StreamingOutputResult[
      Any,
      zio.aws.alexaforbusiness.model.SearchDevicesResponse.ReadOnly,
      zio.aws.alexaforbusiness.model.DeviceData.ReadOnly
    ]
  ] = ZIO.serviceWithZIO(_.searchDevices(request))
  def searchDevicesPaginated(request: SearchDevicesRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.SearchDevicesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.searchDevicesPaginated(request))
  def getContact(request: GetContactRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.GetContactResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getContact(request))
  def resolveRoom(request: ResolveRoomRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.ResolveRoomResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.resolveRoom(request))
  def registerAVSDevice(request: RegisterAvsDeviceRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.RegisterAvsDeviceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.registerAVSDevice(request))
  def updateProfile(request: UpdateProfileRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.UpdateProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateProfile(request))
  def createSkillGroup(request: CreateSkillGroupRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.CreateSkillGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSkillGroup(request))
  def searchProfiles(request: SearchProfilesRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    StreamingOutputResult[
      Any,
      zio.aws.alexaforbusiness.model.SearchProfilesResponse.ReadOnly,
      zio.aws.alexaforbusiness.model.ProfileData.ReadOnly
    ]
  ] = ZIO.serviceWithZIO(_.searchProfiles(request))
  def searchProfilesPaginated(request: SearchProfilesRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.SearchProfilesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.searchProfilesPaginated(request))
  def deleteDeviceUsageData(request: DeleteDeviceUsageDataRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.DeleteDeviceUsageDataResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDeviceUsageData(request))
  def searchContacts(request: SearchContactsRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    StreamingOutputResult[
      Any,
      zio.aws.alexaforbusiness.model.SearchContactsResponse.ReadOnly,
      zio.aws.alexaforbusiness.model.ContactData.ReadOnly
    ]
  ] = ZIO.serviceWithZIO(_.searchContacts(request))
  def searchContactsPaginated(request: SearchContactsRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.SearchContactsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.searchContactsPaginated(request))
  def getDevice(request: GetDeviceRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.GetDeviceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDevice(request))
  def createNetworkProfile(request: CreateNetworkProfileRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.CreateNetworkProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createNetworkProfile(request))
  def createBusinessReportSchedule(
      request: CreateBusinessReportScheduleRequest
  ): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.CreateBusinessReportScheduleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createBusinessReportSchedule(request))
  def getGateway(request: GetGatewayRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.GetGatewayResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getGateway(request))
  def searchNetworkProfiles(request: SearchNetworkProfilesRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    StreamingOutputResult[
      Any,
      zio.aws.alexaforbusiness.model.SearchNetworkProfilesResponse.ReadOnly,
      zio.aws.alexaforbusiness.model.NetworkProfileData.ReadOnly
    ]
  ] = ZIO.serviceWithZIO(_.searchNetworkProfiles(request))
  def searchNetworkProfilesPaginated(
      request: SearchNetworkProfilesRequest
  ): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.SearchNetworkProfilesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.searchNetworkProfilesPaginated(request))
  def searchAddressBooks(request: SearchAddressBooksRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    StreamingOutputResult[
      Any,
      zio.aws.alexaforbusiness.model.SearchAddressBooksResponse.ReadOnly,
      zio.aws.alexaforbusiness.model.AddressBookData.ReadOnly
    ]
  ] = ZIO.serviceWithZIO(_.searchAddressBooks(request))
  def searchAddressBooksPaginated(request: SearchAddressBooksRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.SearchAddressBooksResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.searchAddressBooksPaginated(request))
  def putRoomSkillParameter(request: PutRoomSkillParameterRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.PutRoomSkillParameterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putRoomSkillParameter(request))
  def listGateways(request: ListGatewaysRequest): ZStream[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.GatewaySummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listGateways(request))
  def listGatewaysPaginated(request: ListGatewaysRequest): ZIO[
    zio.aws.alexaforbusiness.AlexaForBusiness,
    AwsError,
    zio.aws.alexaforbusiness.model.ListGatewaysResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listGatewaysPaginated(request))
}
