package zio.aws.alexaforbusiness.model
import java.lang.Integer
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{MaxResults, NextToken}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SearchUsersRequest(
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None,
    filters: Option[Iterable[zio.aws.alexaforbusiness.model.Filter]] = None,
    sortCriteria: Option[Iterable[zio.aws.alexaforbusiness.model.Sort]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.SearchUsersRequest = {
    import SearchUsersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.SearchUsersRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        sortCriteria.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sortCriteria)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.SearchUsersRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.SearchUsersRequest.wrap(buildAwsValue())
}
object SearchUsersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.SearchUsersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.SearchUsersRequest =
      zio.aws.alexaforbusiness.model.SearchUsersRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sortCriteria.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def filters: Option[List[zio.aws.alexaforbusiness.model.Filter.ReadOnly]]
    def sortCriteria: Option[List[zio.aws.alexaforbusiness.model.Sort.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.alexaforbusiness.model.Filter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getSortCriteria: ZIO[Any, AwsError, List[
      zio.aws.alexaforbusiness.model.Sort.ReadOnly
    ]] = AwsError.unwrapOptionField("sortCriteria", sortCriteria)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.SearchUsersRequest
  ) extends zio.aws.alexaforbusiness.model.SearchUsersRequest.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.alexaforbusiness.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.alexaforbusiness.model.primitives.MaxResults(value))
    override val filters
        : Option[List[zio.aws.alexaforbusiness.model.Filter.ReadOnly]] = scala
      .Option(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.alexaforbusiness.model.Filter.wrap(item)
        }.toList
      )
    override val sortCriteria
        : Option[List[zio.aws.alexaforbusiness.model.Sort.ReadOnly]] = scala
      .Option(impl.sortCriteria())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.alexaforbusiness.model.Sort.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.SearchUsersRequest
  ): zio.aws.alexaforbusiness.model.SearchUsersRequest.ReadOnly = new Wrapper(
    impl
  )
}
