package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{
  Arn,
  EnrollmentId,
  Email,
  User_LastName,
  User_FirstName
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UserData(
    userArn: Option[Arn] = None,
    firstName: Option[User_FirstName] = None,
    lastName: Option[User_LastName] = None,
    email: Option[Email] = None,
    enrollmentStatus: Option[zio.aws.alexaforbusiness.model.EnrollmentStatus] =
      None,
    enrollmentId: Option[EnrollmentId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.UserData = {
    import UserData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.UserData
      .builder()
      .optionallyWith(
        userArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.userArn)
      .optionallyWith(
        firstName.map(value => User_FirstName.unwrap(value): java.lang.String)
      )(_.firstName)
      .optionallyWith(
        lastName.map(value => User_LastName.unwrap(value): java.lang.String)
      )(_.lastName)
      .optionallyWith(
        email.map(value => Email.unwrap(value): java.lang.String)
      )(_.email)
      .optionallyWith(enrollmentStatus.map(value => value.unwrap))(
        _.enrollmentStatus
      )
      .optionallyWith(
        enrollmentId.map(value => EnrollmentId.unwrap(value): java.lang.String)
      )(_.enrollmentId)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.UserData.ReadOnly =
    zio.aws.alexaforbusiness.model.UserData.wrap(buildAwsValue())
}
object UserData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.UserData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.UserData =
      zio.aws.alexaforbusiness.model.UserData(
        userArn.map(value => value),
        firstName.map(value => value),
        lastName.map(value => value),
        email.map(value => value),
        enrollmentStatus.map(value => value),
        enrollmentId.map(value => value)
      )
    def userArn: Option[Arn]
    def firstName: Option[User_FirstName]
    def lastName: Option[User_LastName]
    def email: Option[Email]
    def enrollmentStatus
        : Option[zio.aws.alexaforbusiness.model.EnrollmentStatus]
    def enrollmentId: Option[EnrollmentId]
    def getUserArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("userArn", userArn)
    def getFirstName: ZIO[Any, AwsError, User_FirstName] =
      AwsError.unwrapOptionField("firstName", firstName)
    def getLastName: ZIO[Any, AwsError, User_LastName] =
      AwsError.unwrapOptionField("lastName", lastName)
    def getEmail: ZIO[Any, AwsError, Email] =
      AwsError.unwrapOptionField("email", email)
    def getEnrollmentStatus
        : ZIO[Any, AwsError, zio.aws.alexaforbusiness.model.EnrollmentStatus] =
      AwsError.unwrapOptionField("enrollmentStatus", enrollmentStatus)
    def getEnrollmentId: ZIO[Any, AwsError, EnrollmentId] =
      AwsError.unwrapOptionField("enrollmentId", enrollmentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.UserData
  ) extends zio.aws.alexaforbusiness.model.UserData.ReadOnly {
    override val userArn: Option[Arn] = scala
      .Option(impl.userArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
    override val firstName: Option[User_FirstName] = scala
      .Option(impl.firstName())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.User_FirstName(value)
      )
    override val lastName: Option[User_LastName] = scala
      .Option(impl.lastName())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.User_LastName(value)
      )
    override val email: Option[Email] = scala
      .Option(impl.email())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Email(value))
    override val enrollmentStatus
        : Option[zio.aws.alexaforbusiness.model.EnrollmentStatus] = scala
      .Option(impl.enrollmentStatus())
      .map(value => zio.aws.alexaforbusiness.model.EnrollmentStatus.wrap(value))
    override val enrollmentId: Option[EnrollmentId] = scala
      .Option(impl.enrollmentId())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.EnrollmentId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.UserData
  ): zio.aws.alexaforbusiness.model.UserData.ReadOnly = new Wrapper(impl)
}
