package zio.aws.alexaforbusiness.model
import scala.jdk.CollectionConverters._
sealed trait TemperatureUnit {
  def unwrap
      : software.amazon.awssdk.services.alexaforbusiness.model.TemperatureUnit
}
object TemperatureUnit {
  def wrap(
      value: software.amazon.awssdk.services.alexaforbusiness.model.TemperatureUnit
  ): zio.aws.alexaforbusiness.model.TemperatureUnit = value match {
    case software.amazon.awssdk.services.alexaforbusiness.model.TemperatureUnit.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.TemperatureUnit.FAHRENHEIT =>
      val r = FAHRENHEIT
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.TemperatureUnit.CELSIUS =>
      val r = CELSIUS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.alexaforbusiness.model.TemperatureUnit {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.TemperatureUnit =
      software.amazon.awssdk.services.alexaforbusiness.model.TemperatureUnit.UNKNOWN_TO_SDK_VERSION
  }
  case object FAHRENHEIT
      extends zio.aws.alexaforbusiness.model.TemperatureUnit {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.TemperatureUnit =
      software.amazon.awssdk.services.alexaforbusiness.model.TemperatureUnit.FAHRENHEIT
  }
  case object CELSIUS extends zio.aws.alexaforbusiness.model.TemperatureUnit {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.TemperatureUnit =
      software.amazon.awssdk.services.alexaforbusiness.model.TemperatureUnit.CELSIUS
  }
}
