package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.SortKey
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class Sort(
    key: SortKey,
    value: zio.aws.alexaforbusiness.model.SortValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.Sort = {
    import Sort.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.Sort
      .builder()
      .key(SortKey.unwrap(key): java.lang.String)
      .value(value.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.Sort.ReadOnly =
    zio.aws.alexaforbusiness.model.Sort.wrap(buildAwsValue())
}
object Sort {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.Sort
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.Sort =
      zio.aws.alexaforbusiness.model.Sort(key, value)
    def key: SortKey
    def value: zio.aws.alexaforbusiness.model.SortValue
    def getKey: ZIO[Any, Nothing, SortKey] = ZIO.succeed(key)
    def getValue: ZIO[Any, Nothing, zio.aws.alexaforbusiness.model.SortValue] =
      ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.Sort
  ) extends zio.aws.alexaforbusiness.model.Sort.ReadOnly {
    override val key: SortKey =
      zio.aws.alexaforbusiness.model.primitives.SortKey(impl.key())
    override val value: zio.aws.alexaforbusiness.model.SortValue =
      zio.aws.alexaforbusiness.model.SortValue.wrap(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.Sort
  ): zio.aws.alexaforbusiness.model.Sort.ReadOnly = new Wrapper(impl)
}
