package zio.aws.alexaforbusiness.model
import java.lang.Integer
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{TotalCount, NextToken}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SearchAddressBooksResponse(
    addressBooks: Option[
      Iterable[zio.aws.alexaforbusiness.model.AddressBookData]
    ] = None,
    nextToken: Option[NextToken] = None,
    totalCount: Option[TotalCount] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.SearchAddressBooksResponse = {
    import SearchAddressBooksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.SearchAddressBooksResponse
      .builder()
      .optionallyWith(
        addressBooks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.addressBooks)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        totalCount.map(value => TotalCount.unwrap(value): Integer)
      )(_.totalCount)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.SearchAddressBooksResponse.ReadOnly =
    zio.aws.alexaforbusiness.model.SearchAddressBooksResponse
      .wrap(buildAwsValue())
}
object SearchAddressBooksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.SearchAddressBooksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.SearchAddressBooksResponse =
      zio.aws.alexaforbusiness.model.SearchAddressBooksResponse(
        addressBooks.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        totalCount.map(value => value)
      )
    def addressBooks
        : Option[List[zio.aws.alexaforbusiness.model.AddressBookData.ReadOnly]]
    def nextToken: Option[NextToken]
    def totalCount: Option[TotalCount]
    def getAddressBooks: ZIO[Any, AwsError, List[
      zio.aws.alexaforbusiness.model.AddressBookData.ReadOnly
    ]] = AwsError.unwrapOptionField("addressBooks", addressBooks)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getTotalCount: ZIO[Any, AwsError, TotalCount] =
      AwsError.unwrapOptionField("totalCount", totalCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.SearchAddressBooksResponse
  ) extends zio.aws.alexaforbusiness.model.SearchAddressBooksResponse.ReadOnly {
    override val addressBooks: Option[
      List[zio.aws.alexaforbusiness.model.AddressBookData.ReadOnly]
    ] = scala
      .Option(impl.addressBooks())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.alexaforbusiness.model.AddressBookData.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.alexaforbusiness.model.primitives.NextToken(value))
    override val totalCount: Option[TotalCount] = scala
      .Option(impl.totalCount())
      .map(value => zio.aws.alexaforbusiness.model.primitives.TotalCount(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.SearchAddressBooksResponse
  ): zio.aws.alexaforbusiness.model.SearchAddressBooksResponse.ReadOnly =
    new Wrapper(impl)
}
