package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{
  AmazonId,
  DeviceSerialNumberForAVS,
  Arn,
  ClientId,
  ProductId,
  UserCode
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RegisterAvsDeviceRequest(
    clientId: ClientId,
    userCode: UserCode,
    productId: ProductId,
    deviceSerialNumber: Option[DeviceSerialNumberForAVS] = None,
    amazonId: AmazonId,
    roomArn: Option[Arn] = None,
    tags: Option[Iterable[zio.aws.alexaforbusiness.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.RegisterAvsDeviceRequest = {
    import RegisterAvsDeviceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.RegisterAvsDeviceRequest
      .builder()
      .clientId(ClientId.unwrap(clientId): java.lang.String)
      .userCode(UserCode.unwrap(userCode): java.lang.String)
      .productId(ProductId.unwrap(productId): java.lang.String)
      .optionallyWith(
        deviceSerialNumber.map(value =>
          DeviceSerialNumberForAVS.unwrap(value): java.lang.String
        )
      )(_.deviceSerialNumber)
      .amazonId(AmazonId.unwrap(amazonId): java.lang.String)
      .optionallyWith(
        roomArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.roomArn)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.RegisterAvsDeviceRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.RegisterAvsDeviceRequest
      .wrap(buildAwsValue())
}
object RegisterAvsDeviceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.RegisterAvsDeviceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.RegisterAvsDeviceRequest =
      zio.aws.alexaforbusiness.model.RegisterAvsDeviceRequest(
        clientId,
        userCode,
        productId,
        deviceSerialNumber.map(value => value),
        amazonId,
        roomArn.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def clientId: ClientId
    def userCode: UserCode
    def productId: ProductId
    def deviceSerialNumber: Option[DeviceSerialNumberForAVS]
    def amazonId: AmazonId
    def roomArn: Option[Arn]
    def tags: Option[List[zio.aws.alexaforbusiness.model.Tag.ReadOnly]]
    def getClientId: ZIO[Any, Nothing, ClientId] = ZIO.succeed(clientId)
    def getUserCode: ZIO[Any, Nothing, UserCode] = ZIO.succeed(userCode)
    def getProductId: ZIO[Any, Nothing, ProductId] = ZIO.succeed(productId)
    def getDeviceSerialNumber: ZIO[Any, AwsError, DeviceSerialNumberForAVS] =
      AwsError.unwrapOptionField("deviceSerialNumber", deviceSerialNumber)
    def getAmazonId: ZIO[Any, Nothing, AmazonId] = ZIO.succeed(amazonId)
    def getRoomArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("roomArn", roomArn)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.alexaforbusiness.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.RegisterAvsDeviceRequest
  ) extends zio.aws.alexaforbusiness.model.RegisterAvsDeviceRequest.ReadOnly {
    override val clientId: ClientId =
      zio.aws.alexaforbusiness.model.primitives.ClientId(impl.clientId())
    override val userCode: UserCode =
      zio.aws.alexaforbusiness.model.primitives.UserCode(impl.userCode())
    override val productId: ProductId =
      zio.aws.alexaforbusiness.model.primitives.ProductId(impl.productId())
    override val deviceSerialNumber: Option[DeviceSerialNumberForAVS] = scala
      .Option(impl.deviceSerialNumber())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives
          .DeviceSerialNumberForAVS(value)
      )
    override val amazonId: AmazonId =
      zio.aws.alexaforbusiness.model.primitives.AmazonId(impl.amazonId())
    override val roomArn: Option[Arn] = scala
      .Option(impl.roomArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
    override val tags
        : Option[List[zio.aws.alexaforbusiness.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.alexaforbusiness.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.RegisterAvsDeviceRequest
  ): zio.aws.alexaforbusiness.model.RegisterAvsDeviceRequest.ReadOnly =
    new Wrapper(impl)
}
