package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetConferenceProviderResponse(
    conferenceProvider: Option[
      zio.aws.alexaforbusiness.model.ConferenceProvider
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.GetConferenceProviderResponse = {
    import GetConferenceProviderResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.GetConferenceProviderResponse
      .builder()
      .optionallyWith(conferenceProvider.map(value => value.buildAwsValue()))(
        _.conferenceProvider
      )
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.GetConferenceProviderResponse.ReadOnly =
    zio.aws.alexaforbusiness.model.GetConferenceProviderResponse
      .wrap(buildAwsValue())
}
object GetConferenceProviderResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.GetConferenceProviderResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.alexaforbusiness.model.GetConferenceProviderResponse =
      zio.aws.alexaforbusiness.model.GetConferenceProviderResponse(
        conferenceProvider.map(value => value.asEditable)
      )
    def conferenceProvider
        : Option[zio.aws.alexaforbusiness.model.ConferenceProvider.ReadOnly]
    def getConferenceProvider: ZIO[
      Any,
      AwsError,
      zio.aws.alexaforbusiness.model.ConferenceProvider.ReadOnly
    ] = AwsError.unwrapOptionField("conferenceProvider", conferenceProvider)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.GetConferenceProviderResponse
  ) extends zio.aws.alexaforbusiness.model.GetConferenceProviderResponse.ReadOnly {
    override val conferenceProvider
        : Option[zio.aws.alexaforbusiness.model.ConferenceProvider.ReadOnly] =
      scala
        .Option(impl.conferenceProvider())
        .map(value =>
          zio.aws.alexaforbusiness.model.ConferenceProvider.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.GetConferenceProviderResponse
  ): zio.aws.alexaforbusiness.model.GetConferenceProviderResponse.ReadOnly =
    new Wrapper(impl)
}
