package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Content(
    textList: Option[Iterable[zio.aws.alexaforbusiness.model.Text]] = None,
    ssmlList: Option[Iterable[zio.aws.alexaforbusiness.model.Ssml]] = None,
    audioList: Option[Iterable[zio.aws.alexaforbusiness.model.Audio]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.Content = {
    import Content.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.Content
      .builder()
      .optionallyWith(
        textList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.textList)
      .optionallyWith(
        ssmlList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ssmlList)
      .optionallyWith(
        audioList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.audioList)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.Content.ReadOnly =
    zio.aws.alexaforbusiness.model.Content.wrap(buildAwsValue())
}
object Content {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.Content
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.Content =
      zio.aws.alexaforbusiness.model.Content(
        textList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ssmlList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        audioList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def textList: Option[List[zio.aws.alexaforbusiness.model.Text.ReadOnly]]
    def ssmlList: Option[List[zio.aws.alexaforbusiness.model.Ssml.ReadOnly]]
    def audioList: Option[List[zio.aws.alexaforbusiness.model.Audio.ReadOnly]]
    def getTextList: ZIO[Any, AwsError, List[
      zio.aws.alexaforbusiness.model.Text.ReadOnly
    ]] = AwsError.unwrapOptionField("textList", textList)
    def getSsmlList: ZIO[Any, AwsError, List[
      zio.aws.alexaforbusiness.model.Ssml.ReadOnly
    ]] = AwsError.unwrapOptionField("ssmlList", ssmlList)
    def getAudioList: ZIO[Any, AwsError, List[
      zio.aws.alexaforbusiness.model.Audio.ReadOnly
    ]] = AwsError.unwrapOptionField("audioList", audioList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.Content
  ) extends zio.aws.alexaforbusiness.model.Content.ReadOnly {
    override val textList
        : Option[List[zio.aws.alexaforbusiness.model.Text.ReadOnly]] = scala
      .Option(impl.textList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.alexaforbusiness.model.Text.wrap(item)
        }.toList
      )
    override val ssmlList
        : Option[List[zio.aws.alexaforbusiness.model.Ssml.ReadOnly]] = scala
      .Option(impl.ssmlList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.alexaforbusiness.model.Ssml.wrap(item)
        }.toList
      )
    override val audioList
        : Option[List[zio.aws.alexaforbusiness.model.Audio.ReadOnly]] = scala
      .Option(impl.audioList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.alexaforbusiness.model.Audio.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.Content
  ): zio.aws.alexaforbusiness.model.Content.ReadOnly = new Wrapper(impl)
}
