package zio.aws.alexaforbusiness.model
import scala.jdk.CollectionConverters._
sealed trait WakeWord {
  def unwrap: software.amazon.awssdk.services.alexaforbusiness.model.WakeWord
}
object WakeWord {
  def wrap(
      value: software.amazon.awssdk.services.alexaforbusiness.model.WakeWord
  ): zio.aws.alexaforbusiness.model.WakeWord = value match {
    case software.amazon.awssdk.services.alexaforbusiness.model.WakeWord.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.WakeWord.ALEXA =>
      val r = ALEXA
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.WakeWord.AMAZON =>
      val r = AMAZON
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.WakeWord.ECHO =>
      val r = ECHO
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.WakeWord.COMPUTER =>
      val r = COMPUTER
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.alexaforbusiness.model.WakeWord {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.WakeWord =
      software.amazon.awssdk.services.alexaforbusiness.model.WakeWord.UNKNOWN_TO_SDK_VERSION
  }
  case object ALEXA extends zio.aws.alexaforbusiness.model.WakeWord {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.WakeWord =
      software.amazon.awssdk.services.alexaforbusiness.model.WakeWord.ALEXA
  }
  case object AMAZON extends zio.aws.alexaforbusiness.model.WakeWord {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.WakeWord =
      software.amazon.awssdk.services.alexaforbusiness.model.WakeWord.AMAZON
  }
  case object ECHO extends zio.aws.alexaforbusiness.model.WakeWord {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.WakeWord =
      software.amazon.awssdk.services.alexaforbusiness.model.WakeWord.ECHO
  }
  case object COMPUTER extends zio.aws.alexaforbusiness.model.WakeWord {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.WakeWord =
      software.amazon.awssdk.services.alexaforbusiness.model.WakeWord.COMPUTER
  }
}
