package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{
  Arn,
  ProfileName,
  ProviderCalendarId,
  RoomName,
  RoomDescription
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RoomData(
    roomArn: Option[Arn] = None,
    roomName: Option[RoomName] = None,
    description: Option[RoomDescription] = None,
    providerCalendarId: Option[ProviderCalendarId] = None,
    profileArn: Option[Arn] = None,
    profileName: Option[ProfileName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.RoomData = {
    import RoomData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.RoomData
      .builder()
      .optionallyWith(
        roomArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.roomArn)
      .optionallyWith(
        roomName.map(value => RoomName.unwrap(value): java.lang.String)
      )(_.roomName)
      .optionallyWith(
        description.map(value =>
          RoomDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        providerCalendarId.map(value =>
          ProviderCalendarId.unwrap(value): java.lang.String
        )
      )(_.providerCalendarId)
      .optionallyWith(
        profileArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.profileArn)
      .optionallyWith(
        profileName.map(value => ProfileName.unwrap(value): java.lang.String)
      )(_.profileName)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.RoomData.ReadOnly =
    zio.aws.alexaforbusiness.model.RoomData.wrap(buildAwsValue())
}
object RoomData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.RoomData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.RoomData =
      zio.aws.alexaforbusiness.model.RoomData(
        roomArn.map(value => value),
        roomName.map(value => value),
        description.map(value => value),
        providerCalendarId.map(value => value),
        profileArn.map(value => value),
        profileName.map(value => value)
      )
    def roomArn: Option[Arn]
    def roomName: Option[RoomName]
    def description: Option[RoomDescription]
    def providerCalendarId: Option[ProviderCalendarId]
    def profileArn: Option[Arn]
    def profileName: Option[ProfileName]
    def getRoomArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("roomArn", roomArn)
    def getRoomName: ZIO[Any, AwsError, RoomName] =
      AwsError.unwrapOptionField("roomName", roomName)
    def getDescription: ZIO[Any, AwsError, RoomDescription] =
      AwsError.unwrapOptionField("description", description)
    def getProviderCalendarId: ZIO[Any, AwsError, ProviderCalendarId] =
      AwsError.unwrapOptionField("providerCalendarId", providerCalendarId)
    def getProfileArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("profileArn", profileArn)
    def getProfileName: ZIO[Any, AwsError, ProfileName] =
      AwsError.unwrapOptionField("profileName", profileName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.RoomData
  ) extends zio.aws.alexaforbusiness.model.RoomData.ReadOnly {
    override val roomArn: Option[Arn] = scala
      .Option(impl.roomArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
    override val roomName: Option[RoomName] = scala
      .Option(impl.roomName())
      .map(value => zio.aws.alexaforbusiness.model.primitives.RoomName(value))
    override val description: Option[RoomDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.RoomDescription(value)
      )
    override val providerCalendarId: Option[ProviderCalendarId] = scala
      .Option(impl.providerCalendarId())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.ProviderCalendarId(value)
      )
    override val profileArn: Option[Arn] = scala
      .Option(impl.profileArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
    override val profileName: Option[ProfileName] = scala
      .Option(impl.profileName())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.ProfileName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.RoomData
  ): zio.aws.alexaforbusiness.model.RoomData.ReadOnly = new Wrapper(impl)
}
