package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{SkillId, UserId}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ResolveRoomRequest(userId: UserId, skillId: SkillId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.ResolveRoomRequest = {
    import ResolveRoomRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.ResolveRoomRequest
      .builder()
      .userId(UserId.unwrap(userId): java.lang.String)
      .skillId(SkillId.unwrap(skillId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.ResolveRoomRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.ResolveRoomRequest.wrap(buildAwsValue())
}
object ResolveRoomRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.ResolveRoomRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.ResolveRoomRequest =
      zio.aws.alexaforbusiness.model.ResolveRoomRequest(userId, skillId)
    def userId: UserId
    def skillId: SkillId
    def getUserId: ZIO[Any, Nothing, UserId] = ZIO.succeed(userId)
    def getSkillId: ZIO[Any, Nothing, SkillId] = ZIO.succeed(skillId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.ResolveRoomRequest
  ) extends zio.aws.alexaforbusiness.model.ResolveRoomRequest.ReadOnly {
    override val userId: UserId =
      zio.aws.alexaforbusiness.model.primitives.UserId(impl.userId())
    override val skillId: SkillId =
      zio.aws.alexaforbusiness.model.primitives.SkillId(impl.skillId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.ResolveRoomRequest
  ): zio.aws.alexaforbusiness.model.ResolveRoomRequest.ReadOnly = new Wrapper(
    impl
  )
}
