package zio.aws.alexaforbusiness.model
import java.lang.Integer
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{
  Arn,
  DeviceLocale,
  ProfileName,
  MaxVolumeLimit,
  Address,
  Timezone
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Profile(
    profileArn: Option[Arn] = None,
    profileName: Option[ProfileName] = None,
    isDefault: Option[Boolean] = None,
    address: Option[Address] = None,
    timezone: Option[Timezone] = None,
    distanceUnit: Option[zio.aws.alexaforbusiness.model.DistanceUnit] = None,
    temperatureUnit: Option[zio.aws.alexaforbusiness.model.TemperatureUnit] =
      None,
    wakeWord: Option[zio.aws.alexaforbusiness.model.WakeWord] = None,
    locale: Option[DeviceLocale] = None,
    setupModeDisabled: Option[Boolean] = None,
    maxVolumeLimit: Option[MaxVolumeLimit] = None,
    pstnEnabled: Option[Boolean] = None,
    dataRetentionOptIn: Option[Boolean] = None,
    addressBookArn: Option[Arn] = None,
    meetingRoomConfiguration: Option[
      zio.aws.alexaforbusiness.model.MeetingRoomConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.Profile = {
    import Profile.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.Profile
      .builder()
      .optionallyWith(
        profileArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.profileArn)
      .optionallyWith(
        profileName.map(value => ProfileName.unwrap(value): java.lang.String)
      )(_.profileName)
      .optionallyWith(isDefault.map(value => value: java.lang.Boolean))(
        _.isDefault
      )
      .optionallyWith(
        address.map(value => Address.unwrap(value): java.lang.String)
      )(_.address)
      .optionallyWith(
        timezone.map(value => Timezone.unwrap(value): java.lang.String)
      )(_.timezone)
      .optionallyWith(distanceUnit.map(value => value.unwrap))(_.distanceUnit)
      .optionallyWith(temperatureUnit.map(value => value.unwrap))(
        _.temperatureUnit
      )
      .optionallyWith(wakeWord.map(value => value.unwrap))(_.wakeWord)
      .optionallyWith(
        locale.map(value => DeviceLocale.unwrap(value): java.lang.String)
      )(_.locale)
      .optionallyWith(setupModeDisabled.map(value => value: java.lang.Boolean))(
        _.setupModeDisabled
      )
      .optionallyWith(
        maxVolumeLimit.map(value => MaxVolumeLimit.unwrap(value): Integer)
      )(_.maxVolumeLimit)
      .optionallyWith(pstnEnabled.map(value => value: java.lang.Boolean))(
        _.pstnEnabled
      )
      .optionallyWith(
        dataRetentionOptIn.map(value => value: java.lang.Boolean)
      )(_.dataRetentionOptIn)
      .optionallyWith(
        addressBookArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.addressBookArn)
      .optionallyWith(
        meetingRoomConfiguration.map(value => value.buildAwsValue())
      )(_.meetingRoomConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.Profile.ReadOnly =
    zio.aws.alexaforbusiness.model.Profile.wrap(buildAwsValue())
}
object Profile {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.Profile
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.Profile =
      zio.aws.alexaforbusiness.model.Profile(
        profileArn.map(value => value),
        profileName.map(value => value),
        isDefault.map(value => value),
        address.map(value => value),
        timezone.map(value => value),
        distanceUnit.map(value => value),
        temperatureUnit.map(value => value),
        wakeWord.map(value => value),
        locale.map(value => value),
        setupModeDisabled.map(value => value),
        maxVolumeLimit.map(value => value),
        pstnEnabled.map(value => value),
        dataRetentionOptIn.map(value => value),
        addressBookArn.map(value => value),
        meetingRoomConfiguration.map(value => value.asEditable)
      )
    def profileArn: Option[Arn]
    def profileName: Option[ProfileName]
    def isDefault: Option[Boolean]
    def address: Option[Address]
    def timezone: Option[Timezone]
    def distanceUnit: Option[zio.aws.alexaforbusiness.model.DistanceUnit]
    def temperatureUnit: Option[zio.aws.alexaforbusiness.model.TemperatureUnit]
    def wakeWord: Option[zio.aws.alexaforbusiness.model.WakeWord]
    def locale: Option[DeviceLocale]
    def setupModeDisabled: Option[Boolean]
    def maxVolumeLimit: Option[MaxVolumeLimit]
    def pstnEnabled: Option[Boolean]
    def dataRetentionOptIn: Option[Boolean]
    def addressBookArn: Option[Arn]
    def meetingRoomConfiguration: Option[
      zio.aws.alexaforbusiness.model.MeetingRoomConfiguration.ReadOnly
    ]
    def getProfileArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("profileArn", profileArn)
    def getProfileName: ZIO[Any, AwsError, ProfileName] =
      AwsError.unwrapOptionField("profileName", profileName)
    def getIsDefault: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isDefault", isDefault)
    def getAddress: ZIO[Any, AwsError, Address] =
      AwsError.unwrapOptionField("address", address)
    def getTimezone: ZIO[Any, AwsError, Timezone] =
      AwsError.unwrapOptionField("timezone", timezone)
    def getDistanceUnit
        : ZIO[Any, AwsError, zio.aws.alexaforbusiness.model.DistanceUnit] =
      AwsError.unwrapOptionField("distanceUnit", distanceUnit)
    def getTemperatureUnit
        : ZIO[Any, AwsError, zio.aws.alexaforbusiness.model.TemperatureUnit] =
      AwsError.unwrapOptionField("temperatureUnit", temperatureUnit)
    def getWakeWord
        : ZIO[Any, AwsError, zio.aws.alexaforbusiness.model.WakeWord] =
      AwsError.unwrapOptionField("wakeWord", wakeWord)
    def getLocale: ZIO[Any, AwsError, DeviceLocale] =
      AwsError.unwrapOptionField("locale", locale)
    def getSetupModeDisabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("setupModeDisabled", setupModeDisabled)
    def getMaxVolumeLimit: ZIO[Any, AwsError, MaxVolumeLimit] =
      AwsError.unwrapOptionField("maxVolumeLimit", maxVolumeLimit)
    def getPstnEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("pstnEnabled", pstnEnabled)
    def getDataRetentionOptIn: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dataRetentionOptIn", dataRetentionOptIn)
    def getAddressBookArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("addressBookArn", addressBookArn)
    def getMeetingRoomConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.alexaforbusiness.model.MeetingRoomConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "meetingRoomConfiguration",
      meetingRoomConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.Profile
  ) extends zio.aws.alexaforbusiness.model.Profile.ReadOnly {
    override val profileArn: Option[Arn] = scala
      .Option(impl.profileArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
    override val profileName: Option[ProfileName] = scala
      .Option(impl.profileName())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.ProfileName(value)
      )
    override val isDefault: Option[Boolean] =
      scala.Option(impl.isDefault()).map(value => value: Boolean)
    override val address: Option[Address] = scala
      .Option(impl.address())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Address(value))
    override val timezone: Option[Timezone] = scala
      .Option(impl.timezone())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Timezone(value))
    override val distanceUnit
        : Option[zio.aws.alexaforbusiness.model.DistanceUnit] = scala
      .Option(impl.distanceUnit())
      .map(value => zio.aws.alexaforbusiness.model.DistanceUnit.wrap(value))
    override val temperatureUnit
        : Option[zio.aws.alexaforbusiness.model.TemperatureUnit] = scala
      .Option(impl.temperatureUnit())
      .map(value => zio.aws.alexaforbusiness.model.TemperatureUnit.wrap(value))
    override val wakeWord: Option[zio.aws.alexaforbusiness.model.WakeWord] =
      scala
        .Option(impl.wakeWord())
        .map(value => zio.aws.alexaforbusiness.model.WakeWord.wrap(value))
    override val locale: Option[DeviceLocale] = scala
      .Option(impl.locale())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.DeviceLocale(value)
      )
    override val setupModeDisabled: Option[Boolean] =
      scala.Option(impl.setupModeDisabled()).map(value => value: Boolean)
    override val maxVolumeLimit: Option[MaxVolumeLimit] = scala
      .Option(impl.maxVolumeLimit())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.MaxVolumeLimit(value)
      )
    override val pstnEnabled: Option[Boolean] =
      scala.Option(impl.pstnEnabled()).map(value => value: Boolean)
    override val dataRetentionOptIn: Option[Boolean] =
      scala.Option(impl.dataRetentionOptIn()).map(value => value: Boolean)
    override val addressBookArn: Option[Arn] = scala
      .Option(impl.addressBookArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
    override val meetingRoomConfiguration: Option[
      zio.aws.alexaforbusiness.model.MeetingRoomConfiguration.ReadOnly
    ] = scala
      .Option(impl.meetingRoomConfiguration())
      .map(value =>
        zio.aws.alexaforbusiness.model.MeetingRoomConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.Profile
  ): zio.aws.alexaforbusiness.model.Profile.ReadOnly = new Wrapper(impl)
}
