package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{
  Arn,
  NextWiFiPassword,
  NetworkProfileDescription,
  NetworkSsid,
  TrustAnchor,
  CurrentWiFiPassword,
  NetworkProfileName
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class NetworkProfile(
    networkProfileArn: Option[Arn] = None,
    networkProfileName: Option[NetworkProfileName] = None,
    description: Option[NetworkProfileDescription] = None,
    ssid: Option[NetworkSsid] = None,
    securityType: Option[zio.aws.alexaforbusiness.model.NetworkSecurityType] =
      None,
    eapMethod: Option[zio.aws.alexaforbusiness.model.NetworkEapMethod] = None,
    currentPassword: Option[CurrentWiFiPassword] = None,
    nextPassword: Option[NextWiFiPassword] = None,
    certificateAuthorityArn: Option[Arn] = None,
    trustAnchors: Option[Iterable[TrustAnchor]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.NetworkProfile = {
    import NetworkProfile.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.NetworkProfile
      .builder()
      .optionallyWith(
        networkProfileArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.networkProfileArn)
      .optionallyWith(
        networkProfileName.map(value =>
          NetworkProfileName.unwrap(value): java.lang.String
        )
      )(_.networkProfileName)
      .optionallyWith(
        description.map(value =>
          NetworkProfileDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        ssid.map(value => NetworkSsid.unwrap(value): java.lang.String)
      )(_.ssid)
      .optionallyWith(securityType.map(value => value.unwrap))(_.securityType)
      .optionallyWith(eapMethod.map(value => value.unwrap))(_.eapMethod)
      .optionallyWith(
        currentPassword.map(value =>
          CurrentWiFiPassword.unwrap(value): java.lang.String
        )
      )(_.currentPassword)
      .optionallyWith(
        nextPassword.map(value =>
          NextWiFiPassword.unwrap(value): java.lang.String
        )
      )(_.nextPassword)
      .optionallyWith(
        certificateAuthorityArn.map(value =>
          Arn.unwrap(value): java.lang.String
        )
      )(_.certificateAuthorityArn)
      .optionallyWith(
        trustAnchors.map(value =>
          value.map { item =>
            TrustAnchor.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.trustAnchors)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.NetworkProfile.ReadOnly =
    zio.aws.alexaforbusiness.model.NetworkProfile.wrap(buildAwsValue())
}
object NetworkProfile {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.NetworkProfile
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.NetworkProfile =
      zio.aws.alexaforbusiness.model.NetworkProfile(
        networkProfileArn.map(value => value),
        networkProfileName.map(value => value),
        description.map(value => value),
        ssid.map(value => value),
        securityType.map(value => value),
        eapMethod.map(value => value),
        currentPassword.map(value => value),
        nextPassword.map(value => value),
        certificateAuthorityArn.map(value => value),
        trustAnchors.map(value => value)
      )
    def networkProfileArn: Option[Arn]
    def networkProfileName: Option[NetworkProfileName]
    def description: Option[NetworkProfileDescription]
    def ssid: Option[NetworkSsid]
    def securityType: Option[zio.aws.alexaforbusiness.model.NetworkSecurityType]
    def eapMethod: Option[zio.aws.alexaforbusiness.model.NetworkEapMethod]
    def currentPassword: Option[CurrentWiFiPassword]
    def nextPassword: Option[NextWiFiPassword]
    def certificateAuthorityArn: Option[Arn]
    def trustAnchors: Option[List[TrustAnchor]]
    def getNetworkProfileArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("networkProfileArn", networkProfileArn)
    def getNetworkProfileName: ZIO[Any, AwsError, NetworkProfileName] =
      AwsError.unwrapOptionField("networkProfileName", networkProfileName)
    def getDescription: ZIO[Any, AwsError, NetworkProfileDescription] =
      AwsError.unwrapOptionField("description", description)
    def getSsid: ZIO[Any, AwsError, NetworkSsid] =
      AwsError.unwrapOptionField("ssid", ssid)
    def getSecurityType: ZIO[
      Any,
      AwsError,
      zio.aws.alexaforbusiness.model.NetworkSecurityType
    ] = AwsError.unwrapOptionField("securityType", securityType)
    def getEapMethod
        : ZIO[Any, AwsError, zio.aws.alexaforbusiness.model.NetworkEapMethod] =
      AwsError.unwrapOptionField("eapMethod", eapMethod)
    def getCurrentPassword: ZIO[Any, AwsError, CurrentWiFiPassword] =
      AwsError.unwrapOptionField("currentPassword", currentPassword)
    def getNextPassword: ZIO[Any, AwsError, NextWiFiPassword] =
      AwsError.unwrapOptionField("nextPassword", nextPassword)
    def getCertificateAuthorityArn: ZIO[Any, AwsError, Arn] = AwsError
      .unwrapOptionField("certificateAuthorityArn", certificateAuthorityArn)
    def getTrustAnchors: ZIO[Any, AwsError, List[TrustAnchor]] =
      AwsError.unwrapOptionField("trustAnchors", trustAnchors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.NetworkProfile
  ) extends zio.aws.alexaforbusiness.model.NetworkProfile.ReadOnly {
    override val networkProfileArn: Option[Arn] = scala
      .Option(impl.networkProfileArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
    override val networkProfileName: Option[NetworkProfileName] = scala
      .Option(impl.networkProfileName())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.NetworkProfileName(value)
      )
    override val description: Option[NetworkProfileDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives
          .NetworkProfileDescription(value)
      )
    override val ssid: Option[NetworkSsid] = scala
      .Option(impl.ssid())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.NetworkSsid(value)
      )
    override val securityType
        : Option[zio.aws.alexaforbusiness.model.NetworkSecurityType] = scala
      .Option(impl.securityType())
      .map(value =>
        zio.aws.alexaforbusiness.model.NetworkSecurityType.wrap(value)
      )
    override val eapMethod
        : Option[zio.aws.alexaforbusiness.model.NetworkEapMethod] = scala
      .Option(impl.eapMethod())
      .map(value => zio.aws.alexaforbusiness.model.NetworkEapMethod.wrap(value))
    override val currentPassword: Option[CurrentWiFiPassword] = scala
      .Option(impl.currentPassword())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.CurrentWiFiPassword(value)
      )
    override val nextPassword: Option[NextWiFiPassword] = scala
      .Option(impl.nextPassword())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.NextWiFiPassword(value)
      )
    override val certificateAuthorityArn: Option[Arn] = scala
      .Option(impl.certificateAuthorityArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
    override val trustAnchors: Option[List[TrustAnchor]] = scala
      .Option(impl.trustAnchors())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.alexaforbusiness.model.primitives.TrustAnchor(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.NetworkProfile
  ): zio.aws.alexaforbusiness.model.NetworkProfile.ReadOnly = new Wrapper(impl)
}
